/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Building;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.EnergyWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasmaMFUKWeaponHandler
extends EnergyWeaponHandler {
    private static final long serialVersionUID = -6816799343788643259L;

    public PlasmaMFUKWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (entity instanceof Mech) {
            if (!this.bSalvo) {
                this.r = new Report(3390);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
            }
            super.handleEntityDamage(entity, vector, building, n, n2, 0, n4);
            if (this.missed) {
                return;
            }
            this.r = new Report(3400);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.add(5);
            this.r.choose(true);
            this.r.newlines = 0;
            vector.addElement(this.r);
            entity.heatFromExternal += 5;
        } else {
            super.handleEntityDamage(entity, vector, building, n, n2, n3, n4);
        }
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    @Override
    protected void handleIgnitionDamage(Vector<Report> vector, Building building, boolean bl, int n) {
        TargetRoll targetRoll;
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if ((targetRoll = new TargetRoll(this.wtype.getFireTN(), this.wtype.getName())).getValue() != Integer.MAX_VALUE) {
            Report.addNewline(vector);
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, targetRoll, true, -1, vector);
        }
    }

    @Override
    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }
}

