/* Test predicates used by PrologEngineTest.java */
fac(0,0).
fac(1,1).
fac(N,X) :-
    N > 1,
	N1 is N - 1,
	callFac(N1,X1),
	%fac(N1,X1),
	X is N*X1.

:- dynamic ipFactorial/1.

callFac(Arg,Result) :-
	ipFactorial(_ObjectJava), 
	%ipPrologEngine(_ObjectJava),
	ipObjectSpec(int,IntSpec,[Arg],_),
	javaMessage(_ObjectJava,ResultSpec,factorial(IntSpec)),
	ipObjectSpec('java.lang.Integer',ResultSpec,[Result],_).
	
	
fib(0,1).
fib(1,1).
fib(N,X) :-
	N > 1,
	N1 is N - 1,
	%fib(N1,X1),
	callFib(N1,X1),
	N2 is N - 2,
	%fib(N2,X2),
	callFib(N2,X2),
	X is X1+X2.
         
:- dynamic ipFibonaci/1.
        
callFib(Arg,Result) :-
	ipFibonaci(_ObjectJava),
	ipObjectSpec(int,IntSpec,[Arg],_),
	javaMessage(_ObjectJava,ResultSpec,fibonaci(IntSpec)),
	ipObjectSpec('java.lang.Integer',ResultSpec,[Result],_).
	
somaN(0,0).
somaN(1,1).
somaN(N,X) :-
   N > 1,
   N1 is N - 1,
   callSomaN(N1,X1),
   X is N+X1.

:- dynamic ipSomaN/1.

callSomaN(Arg,Result) :-
   ipSomaN(_ObjectJava), 
   ipObjectSpec(int,IntSpec,[Arg],_),
   javaMessage(_ObjectJava,ResultSpec,somaN(IntSpec)),
   ipObjectSpec('java.lang.Integer',ResultSpec,[Result],_).

