/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.builder;

import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.spockframework.builder.ISlot;
import org.spockframework.gentyref.GenericTypeReflector;
import org.spockframework.util.MopUtil;
import org.spockframework.util.UnreachableCodeError;

public class PropertySlot
implements ISlot {
    private final Object owner;
    private final Type ownerType;
    private final MetaProperty property;

    PropertySlot(Object owner, Type ownerType, MetaProperty property) {
        this.owner = owner;
        this.ownerType = ownerType;
        this.property = property;
    }

    @Override
    public Type getType() {
        Method setter = MopUtil.setterFor(this.property);
        if (setter != null) {
            return GenericTypeReflector.getExactParameterTypes(setter, this.ownerType)[0];
        }
        Field field = MopUtil.fieldFor(this.property);
        if (field != null) {
            return GenericTypeReflector.getExactFieldType(field, this.ownerType);
        }
        throw new UnreachableCodeError();
    }

    @Override
    public void write(Object value) {
        this.property.setProperty(this.owner, value);
    }
}

