/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.mock.IInteractionScope;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.TooFewInvocationsError;
import org.spockframework.mock.WrongInvocationOrderError;
import org.spockframework.mock.runtime.MockInteractionDecorator;

public class InteractionScope
implements IInteractionScope {
    private final List<IMockInteraction> interactions = new ArrayList<IMockInteraction>();
    private final List<IMockInvocation> unmatchedInvocations = new ArrayList<IMockInvocation>();
    private int currentRegistrationZone = 0;
    private int currentExecutionZone = 0;

    @Override
    public void addInteraction(IMockInteraction interaction) {
        this.interactions.add(new MockInteractionDecorator(interaction){
            final int myRegistrationZone;
            {
                this.myRegistrationZone = InteractionScope.this.currentRegistrationZone;
            }

            @Override
            public Object accept(IMockInvocation invocation) {
                Object result = super.accept(invocation);
                if (InteractionScope.this.currentExecutionZone > this.myRegistrationZone) {
                    throw new WrongInvocationOrderError(this.decorated, invocation);
                }
                InteractionScope.this.currentExecutionZone = this.myRegistrationZone;
                return result;
            }
        });
    }

    @Override
    public void addOrderingBarrier() {
        ++this.currentRegistrationZone;
    }

    @Override
    public void addUnmatchedInvocation(IMockInvocation invocation) {
        if (invocation.getMockObject().isVerified()) {
            this.unmatchedInvocations.add(invocation);
        }
    }

    @Override
    public IMockInteraction match(IMockInvocation invocation) {
        IMockInteraction firstMatch = null;
        for (IMockInteraction interaction : this.interactions) {
            if (!interaction.matches(invocation)) continue;
            if (!interaction.isExhausted()) {
                return interaction;
            }
            if (firstMatch != null) continue;
            firstMatch = interaction;
        }
        return firstMatch;
    }

    @Override
    public void verifyInteractions() {
        ArrayList<IMockInteraction> unsatisfiedInteractions = new ArrayList<IMockInteraction>();
        for (IMockInteraction interaction : this.interactions) {
            if (interaction.isSatisfied()) continue;
            unsatisfiedInteractions.add(interaction);
        }
        if (!unsatisfiedInteractions.isEmpty()) {
            throw new TooFewInvocationsError(unsatisfiedInteractions, this.unmatchedInvocations);
        }
    }
}

