/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.spockframework.runtime.SpockTimeoutError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.util.TimeUtil;
import spock.lang.Timeout;

public class TimeoutInterceptor
implements IMethodInterceptor {
    private final Timeout timeout;

    public TimeoutInterceptor(Timeout timeout) {
        this.timeout = timeout;
    }

    @Override
    public void intercept(final IMethodInvocation invocation) throws Throwable {
        final Thread mainThread = Thread.currentThread();
        final SynchronousQueue sync = new SynchronousQueue();
        new Thread(String.format("[spock.lang.Timeout] Watcher for method '%s'", invocation.getMethod().getName())){

            @Override
            public void run() {
                StackTraceElement[] stackTrace = new StackTraceElement[]{};
                long waitMillis = TimeoutInterceptor.this.timeout.unit().toMillis(TimeoutInterceptor.this.timeout.value());
                boolean synced = false;
                while (!synced) {
                    try {
                        synced = sync.offer(stackTrace, waitMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    if (synced) continue;
                    if (stackTrace.length == 0) {
                        stackTrace = mainThread.getStackTrace();
                        waitMillis = 250L;
                    } else {
                        System.out.printf("[spock.lang.Timeout] Method '%s' has not yet returned - interrupting. Next try in %1.2f seconds.\n", invocation.getMethod().getName(), (double)(waitMillis *= 2L) / 1000.0);
                    }
                    mainThread.interrupt();
                }
            }
        }.start();
        Throwable saved = null;
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            saved = t;
        }
        StackTraceElement[] stackTrace = null;
        while (stackTrace == null) {
            try {
                stackTrace = (StackTraceElement[])sync.take();
            }
            catch (InterruptedException e) {
                saved = e;
            }
        }
        if (stackTrace.length > 0) {
            double timeoutSeconds = TimeUtil.toSeconds(this.timeout.value(), this.timeout.unit());
            String msg = String.format("Method timed out after %1.2f seconds", timeoutSeconds);
            SpockTimeoutError error = new SpockTimeoutError(timeoutSeconds, msg);
            error.setStackTrace(stackTrace);
            throw error;
        }
        if (saved != null) {
            throw saved;
        }
    }
}

