/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.spockframework.util.CollectionUtil;

public class JsonWriter {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private final Writer out;
    private boolean prettyPrint = false;
    private String indent = "    ";
    private int indentLevel = 0;

    public JsonWriter(Writer out) {
        this.out = out;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void write(Object object) throws IOException {
        if (object == null) {
            this.out.write("null");
        } else if (object instanceof Number) {
            this.writeNumber((Number)object);
        } else if (object.getClass().isArray()) {
            this.writeIterable(CollectionUtil.arrayToList(object));
        } else if (object instanceof Iterable) {
            this.writeIterable((Iterable)object);
        } else if (object instanceof Map) {
            this.writeMap((Map)object);
        } else if (object instanceof Date) {
            this.writeDate((Date)object);
        } else {
            this.writeString(object);
        }
    }

    private void writeNumber(Number number) throws IOException {
        String str = number.toString();
        if (str.equals("NaN") || str.equals("Infinity") || str.equals("-Infinity")) {
            throw new IllegalArgumentException(number + " cannot be represented in JSON");
        }
        this.out.write(str);
    }

    private void writeIterable(Iterable iterable) throws IOException {
        Iterator iterator;
        this.out.write("[");
        if (this.prettyPrint) {
            ++this.indentLevel;
            this.writeNewline();
        }
        if ((iterator = iterable.iterator()).hasNext()) {
            while (true) {
                this.write(iterator.next());
                if (!iterator.hasNext()) break;
                this.out.write(",");
                if (!this.prettyPrint) continue;
                this.writeNewline();
            }
        }
        if (this.prettyPrint) {
            --this.indentLevel;
            this.writeNewline();
        }
        this.out.write("]");
    }

    private <K, V> void writeMap(Map<K, V> map) throws IOException {
        Iterator<Map.Entry<K, V>> iterator;
        this.out.write("{");
        if (this.prettyPrint) {
            ++this.indentLevel;
            this.writeNewline();
        }
        if ((iterator = map.entrySet().iterator()).hasNext()) {
            while (true) {
                Map.Entry<K, V> entry = iterator.next();
                this.writeString(entry.getKey());
                this.out.write(":");
                if (this.prettyPrint) {
                    this.out.write(" ");
                }
                this.write(entry.getValue());
                if (!iterator.hasNext()) break;
                this.out.write(",");
                if (!this.prettyPrint) continue;
                this.writeNewline();
            }
        }
        if (this.prettyPrint) {
            --this.indentLevel;
            this.writeNewline();
        }
        this.out.write("}");
    }

    private void writeDate(Date date) throws IOException {
        this.writeString(dateFormat.format(date));
    }

    private void writeString(Object object) throws IOException {
        this.out.write("\"");
        String str = object.toString();
        if (str == null) {
            throw new IllegalArgumentException("Non-null object of type '" + object.getClass() + "' returned 'null' toString() representation");
        }
        int sz = str.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                this.out.write("\\u" + this.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                this.out.write("\\u0" + this.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                this.out.write("\\u00" + this.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        this.out.write(92);
                        this.out.write(98);
                        break;
                    }
                    case '\n': {
                        this.out.write(92);
                        this.out.write(110);
                        break;
                    }
                    case '\t': {
                        this.out.write(92);
                        this.out.write(116);
                        break;
                    }
                    case '\f': {
                        this.out.write(92);
                        this.out.write(102);
                        break;
                    }
                    case '\r': {
                        this.out.write(92);
                        this.out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            this.out.write("\\u00" + this.hex(ch));
                            break;
                        }
                        this.out.write("\\u000" + this.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    this.out.write(92);
                    this.out.write(34);
                    continue block12;
                }
                case '\\': {
                    this.out.write(92);
                    this.out.write(92);
                    continue block12;
                }
                case '/': {
                    this.out.write(92);
                    this.out.write(47);
                    continue block12;
                }
                default: {
                    this.out.write(ch);
                }
            }
        }
        this.out.write("\"");
    }

    private void writeNewline() throws IOException {
        this.out.write("\n");
        for (int i = 0; i < this.indentLevel; ++i) {
            this.out.write(this.indent);
        }
    }

    private String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

