/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.application.document;

import com.jgoodies.app.gui.application.document.Document;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.components.util.TextComponentUtils;
import com.jgoodies.dialogs.basics.StandardPaneBuilder;
import com.jgoodies.dialogs.core.CommandValue;
import java.util.EventObject;
import java.util.List;

public final class DocumentUtils {
    private DocumentUtils() {
    }

    public static Promise<Boolean> reviewIfChanged(EventObject evt, Document document) {
        if (document == null) {
            return Promise.of(true);
        }
        TextComponentUtils.commitImmediately();
        if (!document.isChanged()) {
            return Promise.of(true);
        }
        CommandValue result = ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showSaveChangesConfirmation(document.getObjectName(), new Object[0]);
        if (result == CommandValue.CANCEL) {
            document.closeDocument(evt);
            return Promise.of(false);
        }
        if (result == CommandValue.DONT_SAVE) {
            document.closeDocument(evt);
            return Promise.of(true);
        }
        return document.saveDocument(evt).thenApply(saved -> {
            if (saved.booleanValue()) {
                document.closeDocument(evt);
            }
            return saved;
        });
    }

    public static Promise<Boolean> applicationExiting(EventObject evt, List<? extends Document> documents) {
        return DocumentUtils.reviewChangedDocuments(evt, documents).thenApply(proceed -> proceed != false && ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showExitConfirmation());
    }

    private static Promise<Boolean> reviewChangedDocuments(EventObject evt, List<? extends Document> changedDocuments) {
        if (changedDocuments.isEmpty()) {
            return Promise.of(true);
        }
        if (changedDocuments.size() == 1) {
            return DocumentUtils.reviewIfChanged(evt, changedDocuments.get(0));
        }
        CommandValue result = ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showSaveAllChangesConfirmation(changedDocuments.size());
        if (result == CommandValue.CANCEL) {
            return Promise.of(false);
        }
        if (result == CommandValue.DISCARD_ALL_CHANGES) {
            for (Document document : changedDocuments) {
                document.closeDocument(evt);
            }
            return Promise.of(true);
        }
        return DocumentUtils.saveDocuments(evt, changedDocuments, result == CommandValue.REVIEW_CHANGES);
    }

    private static Promise<Boolean> saveDocuments(EventObject evt, List<? extends Document> changedDocuments, boolean review) {
        if (changedDocuments.isEmpty()) {
            return Promise.of(true);
        }
        Document first = changedDocuments.get(0);
        List<? extends Document> rest = changedDocuments.subList(1, changedDocuments.size());
        Promise<Boolean> firstPromise = review ? DocumentUtils.reviewIfChanged(evt, first) : first.saveDocument(evt);
        return firstPromise.thenCompose(saved -> {
            if (!saved.booleanValue()) {
                return Promise.of(false);
            }
            first.closeDocument(evt);
            return DocumentUtils.saveDocuments(evt, rest, review);
        });
    }
}

