/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.JGButton;
import com.jgoodies.components.JGSplitButton;
import com.jgoodies.components.internal.TextFieldIcons;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class JGMenuButton
extends JGButton {
    private final Icon popupIcon;
    private JPopupMenu menu;

    public JGMenuButton(Action action, JPopupMenu menu) {
        super(action);
        this.setMenu(menu);
        this.popupIcon = this.getPopupIcon();
        this.initEventHandling();
    }

    public JGMenuButton(Icon icon, JPopupMenu menu) {
        this(null, icon, menu);
    }

    public JGMenuButton(String text, JPopupMenu menu) {
        this(text, null, menu);
    }

    public JGMenuButton(String text, Icon icon, JPopupMenu menu) {
        super(text, icon);
        this.setMenu(menu);
        this.popupIcon = this.getPopupIcon();
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.addActionListener(this::onButtonPerformed);
        this.addKeyListener(Listeners.keyPressed(this::onKeyPressed, "alt"));
    }

    public final JPopupMenu getMenu() {
        return this.menu;
    }

    public final void setMenu(JPopupMenu popupMenu) {
        this.menu = Preconditions.checkNotNull(popupMenu, "The %s must not be null.", "popup menu");
    }

    private void onButtonPerformed(ActionEvent evt) {
        JGMenuButton.showMenu(evt);
    }

    private void onKeyPressed(KeyEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (evt.getKeyCode() == 40) {
            evt.consume();
            JGMenuButton.showMenu(evt);
        }
    }

    private static void showMenu(EventObject evt) {
        JGMenuButton b = (JGMenuButton)evt.getSource();
        if (!b.isShowing()) {
            return;
        }
        b.getMenu().show(b, 0, b.getHeight() + 1);
    }

    @Override
    public void setMargin(Insets margin) {
        super.setMargin(new Insets(margin.top, margin.left, margin.bottom, margin.right + this.getPopupAreaWidth()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintPopupIcon(g);
    }

    private void paintPopupIcon(Graphics g) {
        Insets insets = this.getInsets();
        int x = this.getPopupAreaX() + (this.getPopupAreaWidth() - this.popupIcon.getIconWidth()) / 2;
        int y = insets.top + 1 + (this.getHeight() - insets.top - insets.bottom - this.popupIcon.getIconHeight()) / 2;
        this.popupIcon.paintIcon(this, g, x, y);
    }

    protected int getPopupAreaWidth() {
        return JGSplitButton.POPUP_AREA_WIDTH;
    }

    private int getPopupAreaX() {
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        return this.getWidth() - (insets.right - margin.right) - this.getPopupAreaWidth() + this.getPopupPlatformOffsetX();
    }

    protected int getPopupPlatformOffsetX() {
        return SystemUtils.IS_OS_MAC && this.getIcon() == null ? 11 : 0;
    }

    protected Icon getPopupIcon() {
        return TextFieldIcons.getPopupIcon();
    }
}

