/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.file;

import java.io.File;
import java.util.Enumeration;
import java.util.stream.Stream;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

final class DirectoryTreeNode
extends DefaultMutableTreeNode {
    private final FileSystemView fileSystemView;
    private final boolean deferLoadingChildren;
    private boolean childrenAreLoaded;

    private DirectoryTreeNode(File directory, FileSystemView fileSystemView) {
        this(directory, true, fileSystemView);
    }

    private DirectoryTreeNode(File directory, boolean deferLoadingChildren, FileSystemView fileSystemView) {
        super(directory);
        this.deferLoadingChildren = deferLoadingChildren;
        this.fileSystemView = fileSystemView;
        this.childrenAreLoaded = false;
    }

    private DirectoryTreeNode(String name, File[] children, FileSystemView fileSystemView) {
        super(name);
        this.deferLoadingChildren = true;
        this.fileSystemView = fileSystemView;
        this.addChildren(children);
    }

    public static DirectoryTreeNode createRoot(FileSystemView fileSystemView) {
        return new DirectoryTreeNode("Filesystem Roots", fileSystemView.getRoots(), fileSystemView);
    }

    protected void addChildren(File[] theChildren) {
        this.childrenAreLoaded = true;
        for (File element : theChildren) {
            this.add(new DirectoryTreeNode(element, true, this.fileSystemView));
        }
    }

    public Enumeration children() {
        this.ensureChildrenAreLoaded();
        return super.children();
    }

    @Override
    public TreeNode getChildAt(int index) {
        this.ensureChildrenAreLoaded();
        return super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenAreLoaded();
        return super.getChildCount();
    }

    @Override
    public boolean isLeaf() {
        return !this.childrenAreLoaded && this.shouldDeferLoadingChildren() ? false : super.isLeaf();
    }

    private void ensureChildrenAreLoaded() {
        if (!this.childrenAreLoaded) {
            this.loadChildren();
        }
    }

    public File getDirectory() {
        return (File)this.getUserObject();
    }

    public boolean isFileSystem() {
        return this.fileSystemView.isFileSystem(this.getDirectory());
    }

    public void loadChildren() {
        if (this.childrenAreLoaded) {
            return;
        }
        File directory = this.getDirectory();
        this.childrenAreLoaded = true;
        File[] fileList = this.fileSystemView.getFiles(directory, false);
        if (null == fileList) {
            return;
        }
        Stream.of(fileList).filter(File::isDirectory).sorted().forEach(file -> this.add(new DirectoryTreeNode((File)file, this.fileSystemView)));
    }

    protected boolean shouldDeferLoadingChildren() {
        return this.deferLoadingChildren;
    }
}

