/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.selection;

import com.jgoodies.framework.selection.AbstractRowSelectionManager;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public final class TableRowSelectionManager
extends AbstractRowSelectionManager {
    private final JTable table;

    public TableRowSelectionManager(JTable table) {
        this.table = table;
    }

    @Override
    protected int getSelectedIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    @Override
    protected void setSelectedIndex(int newIndex) {
        this.getSelectionModel().setSelectionInterval(newIndex, newIndex);
        this.ensureIndexIsVisible(newIndex);
    }

    @Override
    protected int getRowCount() {
        return this.table.getRowCount();
    }

    private void ensureIndexIsVisible(int index) {
        Rectangle rect = this.table.getCellRect(index, 0, true);
        this.table.scrollRectToVisible(rect);
    }

    private ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }
}

