/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.invoke;

import java.lang.reflect.Method;
import org.onemind.commons.invoke.AbstractInvocable;
import org.onemind.commons.invoke.AbstractInvocableFunction;
import org.onemind.commons.invoke.InvocableFunction;
import org.onemind.commons.java.lang.reflect.ReflectUtils;

public class ReflectionWrapperInvocable
extends AbstractInvocable {
    private Object _obj;
    private boolean _reflect;

    public ReflectionWrapperInvocable(Object obj) {
        this(obj, true);
    }

    public ReflectionWrapperInvocable(Object obj, boolean useReflect) {
        this._obj = obj;
        this._reflect = useReflect;
    }

    public boolean canInvoke(String functionName, Object[] args) {
        boolean result = super.canInvoke(functionName, args);
        if (!result && this._reflect) {
            try {
                ReflectUtils.getMethod(this._obj.getClass(), functionName, args);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return result;
    }

    public InvocableFunction getFunction(String functionName, Object[] args) {
        InvocableFunction f = super.getFunction(functionName, args);
        if (f == null && this._reflect) {
            try {
                Method m = ReflectUtils.getMethod(this._obj.getClass(), functionName, args);
                f = new ReflectMethodFunction(m);
                this.addFunction(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return f;
    }

    public Object invoke(String functionName, Object[] args) throws Exception {
        InvocableFunction f = this.getFunction(functionName, args);
        if (f != null) {
            return f.invoke(this._obj, args);
        }
        throw new NoSuchMethodError("Method " + ReflectUtils.toMethodString(functionName, args) + " not found");
    }

    private class ReflectMethodFunction
    extends AbstractInvocableFunction {
        private Method _method;

        public ReflectMethodFunction(Method method) {
            super(method.getName(), method.getParameterTypes());
            this._method = method;
        }

        public Object invoke(Object target, Object[] args) throws Exception {
            return this._method.invoke(target, args);
        }
    }
}

