/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.core.AbstractTrieSetMultimap;
import io.usethesource.capsule.core.trie.MultimapNode;
import io.usethesource.capsule.core.trie.MultimapResult;
import io.usethesource.capsule.core.trie.MultimapResultImpl;
import io.usethesource.capsule.util.EqualityComparator;
import java.io.Serializable;

public abstract class AbstractPersistentTrieSetMultimap<K, V, C extends Iterable<V>, R extends MultimapNode<K, V, C, R>>
extends AbstractTrieSetMultimap<K, V, C, R>
implements SetMultimap.Immutable<K, V>,
Serializable {
    private static final long serialVersionUID = 42L;
    protected static final boolean DEBUG = false;
    protected final R rootNode;
    protected final int cachedSize;
    protected final int cachedKeySetSize;
    protected final int cachedKeySetHashCode;

    protected AbstractPersistentTrieSetMultimap(EqualityComparator<Object> cmp, R rootNode, int cachedSize, int keySetHashCode, int keySetSize) {
        super(cmp);
        this.rootNode = rootNode;
        this.cachedSize = cachedSize;
        this.cachedKeySetHashCode = keySetHashCode;
        this.cachedKeySetSize = keySetSize;
    }

    @Override
    final R getRootNode() {
        return this.rootNode;
    }

    @Override
    final int getCachedSize() {
        return this.cachedSize;
    }

    @Override
    final int getCachedKeySetHashCode() {
        return this.cachedKeySetHashCode;
    }

    @Override
    final int getCachedKeySetSize() {
        return this.cachedKeySetSize;
    }

    protected abstract SetMultimap.Immutable<K, V> wrap(EqualityComparator<Object> var1, R var2, int var3, int var4, int var5);

    @Override
    public final SetMultimap.Immutable<K, V> __insert(K key, V value) {
        return this.__insert(key, this.valueToTemporaryBox(value));
    }

    @Override
    public final SetMultimap.Immutable<K, V> __insert(K key, Set.Immutable<V> valueCollection) {
        if (valueCollection.isEmpty()) {
            return this;
        }
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object values = this.collectionToInternalFormat(valueCollection);
        Object newRootNode = this.rootNode.inserted(null, key, values, AbstractPersistentTrieSetMultimap.transformHashCode(keyHash), 0, details, this.cmp);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return this;
            }
            case INSERTED_PAYLOAD: {
                int propertySize = this.cachedSize + details.sizeDelta().get();
                int propertyKeySetHashCode = this.cachedKeySetHashCode;
                int propertyKeySetSize = this.cachedKeySetSize;
                if (details.containsModification(MultimapResult.Modification.INSERTED_KEY)) {
                    propertyKeySetHashCode += keyHash;
                    ++propertyKeySetSize;
                }
                return this.wrap(this.cmp, newRootNode, propertySize, propertyKeySetHashCode, propertyKeySetSize);
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    @Override
    public final SetMultimap.Immutable<K, V> __put(K key, V value) {
        return this.__put(key, this.valueToTemporaryBox(value));
    }

    @Override
    public final SetMultimap.Immutable<K, V> __put(K key, Set.Immutable<V> valueCollection) {
        if (valueCollection.isEmpty()) {
            return this.__remove(key);
        }
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object values = this.collectionToInternalFormat(valueCollection);
        Object newRootNode = this.rootNode.updated(null, key, values, AbstractPersistentTrieSetMultimap.transformHashCode(keyHash), 0, details, this.cmp);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return this;
            }
            case REPLACED_PAYLOAD: {
                Set.Immutable evictedValueCollection = this.internalFormatToCollection((Iterable)details.getEvictedPayload().get());
                int propertySize = this.cachedSize - evictedValueCollection.size() + valueCollection.size();
                int propertyKeySetHashCode = this.cachedKeySetHashCode;
                int propertyKeySetSize = this.cachedKeySetSize;
                return this.wrap(this.cmp, newRootNode, propertySize, propertyKeySetHashCode, propertyKeySetSize);
            }
            case INSERTED_PAYLOAD: {
                assert (details.containsModification(MultimapResult.Modification.INSERTED_KEY));
                int propertySize = this.cachedSize + valueCollection.size();
                int propertyKeySetHashCode = this.cachedKeySetHashCode + keyHash;
                int propertyKeySetSize = this.cachedKeySetSize + 1;
                return this.wrap(this.cmp, newRootNode, propertySize, propertyKeySetHashCode, propertyKeySetSize);
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    @Override
    public final SetMultimap.Immutable<K, V> __remove(K key, V value) {
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object newRootNode = this.rootNode.removed(null, key, value, AbstractPersistentTrieSetMultimap.transformHashCode(keyHash), 0, details, this.cmp);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return this;
            }
            case REMOVED_PAYLOAD: {
                int propertySize = this.cachedSize - 1;
                int propertyKeySetHashCode = this.cachedKeySetHashCode;
                int propertyKeySetSize = this.cachedKeySetSize;
                if (details.containsModification(MultimapResult.Modification.REMOVED_KEY)) {
                    propertyKeySetHashCode -= keyHash;
                    --propertyKeySetSize;
                }
                return this.wrap(this.cmp, newRootNode, propertySize, propertyKeySetHashCode, propertyKeySetSize);
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }

    @Override
    public final SetMultimap.Immutable<K, V> __remove(K key) {
        int keyHash = key.hashCode();
        MultimapResultImpl details = MultimapResult.unchanged();
        Object newRootNode = this.rootNode.removed(null, key, AbstractPersistentTrieSetMultimap.transformHashCode(keyHash), 0, details, this.cmp);
        switch (details.getModificationEffect()) {
            case NOTHING: {
                return this;
            }
            case REMOVED_PAYLOAD: {
                assert (details.containsModification(MultimapResult.Modification.REMOVED_KEY));
                Set.Immutable evictedValueCollection = this.internalFormatToCollection((Iterable)details.getEvictedPayload().get());
                int propertySize = this.cachedSize - evictedValueCollection.size();
                int propertyKeySetHashCode = this.cachedKeySetHashCode - keyHash;
                int propertyKeySetSize = this.cachedKeySetSize - 1;
                return this.wrap(this.cmp, newRootNode, propertySize, propertyKeySetHashCode, propertyKeySetSize);
            }
        }
        throw new IllegalStateException("Unhandled modification effect.");
    }
}

