/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

public class CSVUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(InputStream inputStream, CSV io) throws IOException {
        InputStreamReader inputStreamTxt = new InputStreamReader(inputStream);
        boolean inside = false;
        int how = 0;
        int count = 0;
        StringBuffer buf = new StringBuffer();
        io.newLine();
        try {
            int c;
            while ((c = inputStreamTxt.read()) != -1) {
                if (c == 13) continue;
                if (!inside) {
                    if (c == 34) {
                        inside = true;
                        how = (char)c;
                        continue;
                    }
                    if (c == 10) {
                        io.newValue(count, buf.toString().trim());
                        buf = new StringBuffer();
                        count = 0;
                        io.newLine();
                        continue;
                    }
                    if (c == 44) {
                        io.newValue(count, buf.toString().trim());
                        buf = new StringBuffer();
                        ++count;
                        continue;
                    }
                    buf.append((char)c);
                    continue;
                }
                if (c == how) {
                    inside = false;
                    continue;
                }
                buf.append((char)c);
            }
        }
        finally {
            try {
                if (inputStreamTxt != null) {
                    inputStreamTxt.close();
                }
            }
            catch (IOException ex) {
                Logger.info(null, ex);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                Logger.info(null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(OutputStream out, CSV io, Vector objects, int count) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(out);
            for (int a = 0; a < objects.size(); ++a) {
                Object obj = objects.elementAt(a);
                StringBuffer buffer = new StringBuffer();
                for (int c = 0; c < count; ++c) {
                    String newString = io.getValueAt(obj, c);
                    if (newString != null && newString.indexOf(34) >= 0) {
                        newString = StringUtil.replaceAll(newString, "\"", "''");
                    }
                    if (newString != null && (newString.indexOf(44) >= 0 || newString.indexOf(10) >= 0)) {
                        buffer.append("\"");
                        buffer.append(newString);
                        buffer.append("\"");
                    } else if (newString != null) {
                        buffer.append(newString);
                    }
                    if (c >= count - 1) continue;
                    buffer.append(",");
                }
                writer.write(buffer.toString());
                writer.write("\n");
            }
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException ex) {
                Logger.info(null, ex);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.info(null, ex);
            }
        }
    }

    public static interface CSV {
        public void newLine();

        public void newValue(int var1, String var2);

        public String getValueAt(Object var1, int var2);
    }
}

