/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.Logging;

public final class RightAndLefthandTraffic {
    private static final String DRIVING_SIDE = "driving_side";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static volatile GeoPropertyIndex<Boolean> rlCache;

    private RightAndLefthandTraffic() {
    }

    public static synchronized boolean isRightHandTraffic(LatLon ll) {
        Boolean value = rlCache.get(ll);
        return value == null || value == false;
    }

    static synchronized void initialize(DefaultGeoProperty geoProperty) {
        rlCache = new GeoPropertyIndex<Boolean>(geoProperty, 24);
    }

    static void appendLeftDrivingBoundaries(OsmPrimitive osm, Collection<Way> ways) {
        if (LEFT.equals(osm.get(DRIVING_SIDE))) {
            if (osm instanceof Way) {
                Way w = (Way)osm;
                RightAndLefthandTraffic.addWayIfNotInner(ways, w);
            } else if (osm instanceof Relation && osm.isMultipolygon()) {
                Relation r = (Relation)osm;
                for (RelationMember rm : r.getMembers()) {
                    if (!rm.isWay() || !"outer".equals(rm.getRole()) || RIGHT.equals(rm.getMember().get(DRIVING_SIDE))) continue;
                    RightAndLefthandTraffic.addWayIfNotInner(ways, (Way)rm.getMember());
                }
            }
        }
    }

    private static void addWayIfNotInner(Collection<Way> ways, Way w) {
        Set<Way> s = Collections.singleton(w);
        for (Relation r : OsmPrimitive.getParentRelations(s)) {
            if (!r.isMultipolygon() || !LEFT.equals(r.get(DRIVING_SIDE)) || !"inner".equals(r.getMembersFor(s).iterator().next().getRole())) continue;
            if (Logging.isDebugEnabled()) {
                Logging.debug("Skipping {0} because inner part of {1}", w.get("name:en"), r.get("name:en"));
            }
            return;
        }
        ways.add(w);
    }
}

