/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public Control topControl;

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < children.length; ++i) {
            Point size = children[i].computeSize(wHint, hHint, flushCache);
            maxWidth = Math.max(size.x, maxWidth);
            maxHeight = Math.max(size.y, maxHeight);
        }
        int width = maxWidth + 2 * this.marginWidth;
        int height = maxHeight + 2 * this.marginHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    @Override
    protected boolean flushCache(Control control) {
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle rect = composite.getClientArea();
        rect.x += this.marginWidth;
        rect.y += this.marginHeight;
        rect.width -= 2 * this.marginWidth;
        rect.height -= 2 * this.marginHeight;
        for (int i = 0; i < children.length; ++i) {
            children[i].setBounds(rect);
            children[i].setVisible(children[i] == this.topControl);
        }
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        String string = this.getName() + " {";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.topControl != null) {
            string = string + "topControl=" + this.topControl + " ";
        }
        string = string.trim();
        string = string + "}";
        return string;
    }
}

