//
//  CLDateElement+Graphics.m
//  DateLine
//
//  Created by Alex Clarke on 8/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLManagedGraphic.h"
#import "CLDateElement.h"
#import "CLDateElement+Graphics.h"
#import "NSBezierPath+CLExtensions.h"
#import "XMArgumentKeys.h"


@implementation CLDateElement (Graphics)

-(void) drawElementInView:(NSView *)aView {
	
	//set values for dimensions
	[self setWidth:24.0];
	[self setHeight:40.0];

	NSRect bounds = NSMakeRect (xLoc-(width/2), yLoc-(height/2), width, height); 
	// draw from the centre
	
	[self drawElementInRect:bounds];	
}

-(void) drawElementInRect:(NSRect)sourceRect {
	
	NSUserDefaults * defaults = [NSUserDefaults standardUserDefaults];
	
	NSString * dayTextLabel;

	float fontSize = [[defaults valueForKey:kXMFontSize] floatValue];
	float weekdayFontSize;
	
	if ([[defaults valueForKey:kXMDayStringFormat] intValue] == XMTwoLetterDay) {
		
		dayTextLabel = [[[self valueForKey:@"date"] descriptionWithCalendarFormat:@"%A" timeZone:nil locale:[[NSUserDefaults standardUserDefaults] dictionaryRepresentation]] substringToIndex:2];
		weekdayFontSize = [[defaults valueForKey:kXMFontSize] floatValue] -1;

	}
	else if ([[defaults valueForKey:kXMDayStringFormat] intValue] == XMOneLetterDay) {
		
		dayTextLabel = [[[self valueForKey:@"date"] descriptionWithCalendarFormat:@"%a" timeZone:nil locale:[[NSUserDefaults standardUserDefaults] dictionaryRepresentation]] substringToIndex:1];
		weekdayFontSize = [[defaults valueForKey:kXMFontSize] floatValue];
	}

	NSString * fontName = [defaults valueForKey:kXMFontName];
	NSString * todayFontName = [defaults valueForKey:kXMTodayFontName];
	
	NSFont * font = [NSFont fontWithName:fontName size:fontSize];
	NSFont * weekdayFont = [NSFont fontWithName:fontName size:weekdayFontSize];
	NSFont * todayFont = [NSFont fontWithName:todayFontName size:fontSize];

	hCentre = NSMidX(sourceRect);
	vCentre = NSMidY(sourceRect);
	
	NSColor * background = [self color];
	
	[background set]; 
	[NSBezierPath fillRoundRectInRect:sourceRect radius:6];
	
	//Draw shadow if we'll see it
	NSShadow * shadow = nil;
	if (shadowOffset > 0.00001)	
	{
		float shadowXOffset = sin(shadowAngle)*shadowOffset; 
		float shadowYOffset = cos(shadowAngle)*shadowOffset;
		shadow = [[NSShadow alloc] init];
		[shadow setShadowOffset:(NSMakeSize(shadowXOffset,shadowYOffset))];
		[shadow setShadowBlurRadius:shadowOffset];
		[shadow set];
	}	
	
	//Mark each day
	[self drawDayMark];

	//Mark today	
	if ([[self valueForKey:@"isToday"] isEqual:[NSNumber numberWithBool:YES]])
	{
		if ([[defaults valueForKey:kXMMarkShape] isEqualToString:kXMSquareMarkShape])
			[self drawTodayMarkSquare];
		else if ([[defaults valueForKey:kXMMarkShape] isEqualToString:kXMDiamondMarkShape])
			[self drawTodayMarkDiamond];
	}
		
	//Day Letter attributes
	NSSize overallTextSize;
	NSMutableDictionary * dayTextAttributes=[NSMutableDictionary dictionary];
	[dayTextAttributes setObject:weekdayFont forKey:NSFontAttributeName];
	[dayTextAttributes setObject:[self textColor] forKey:NSForegroundColorAttributeName];
	NSMutableParagraphStyle * dayStyle = [[NSMutableParagraphStyle defaultParagraphStyle] mutableCopy];
	[dayStyle setAlignment:NSCenterTextAlignment];
	[dayTextAttributes setObject:dayStyle forKey:NSParagraphStyleAttributeName];

	//Sunday
	NSMutableDictionary * sundayTextAttributes=[NSMutableDictionary dictionary];
	[sundayTextAttributes setObject:weekdayFont forKey:NSFontAttributeName];
	[sundayTextAttributes setObject:[self textColor] forKey:NSForegroundColorAttributeName];

	//Today
	NSMutableDictionary * todayTextAttributes = [NSMutableDictionary dictionary];
	[todayTextAttributes setObject:todayFont forKey:NSFontAttributeName];
//	NSColor * todayTextCol = [NSUnarchiver unarchiveObjectWithData: [self todayTextColor]];
//	NSLog(@"today %@", [self todayTextColor]);
//	NSLog(@"day %@", [self textColor]);
	[todayTextAttributes setObject:[self textColor] forKey:NSForegroundColorAttributeName];

	// Draw the label
	overallTextSize = [dayTextLabel sizeWithAttributes:dayTextAttributes];

	float labelHLoc = (hCentre - overallTextSize.width/2);
	float labelVLoc = ((vCentre + overallTextSize.height)/2)+20-fontSize;

	if ([[self valueForKey:@"isToday"] isEqual:[NSNumber numberWithBool:YES]])
	{
		[dayTextLabel drawAtPoint:NSMakePoint(labelHLoc,labelVLoc)
				   withAttributes:todayTextAttributes];			
	}
	else if ([[[self valueForKey:@"date"] descriptionWithCalendarFormat:@"%w" timeZone:nil locale:nil] isEqualToString: @"0"])
	{
		[dayTextLabel drawAtPoint:NSMakePoint(labelHLoc,labelVLoc)
				   withAttributes:sundayTextAttributes];
	}
	else
	{
		[dayTextLabel drawAtPoint:NSMakePoint(labelHLoc,labelVLoc)
				   withAttributes:dayTextAttributes];			
	}
	
	//date attributes
	NSMutableDictionary * dateTextAttributes=[NSMutableDictionary dictionary];
	[dateTextAttributes setObject:font
                           forKey:NSFontAttributeName];
	[dateTextAttributes setObject:[self textColor]
                           forKey:NSForegroundColorAttributeName];
	NSMutableParagraphStyle * style = [[NSMutableParagraphStyle defaultParagraphStyle] mutableCopy];
	[style setAlignment:NSCenterTextAlignment];
	[dateTextAttributes setObject:style forKey:NSParagraphStyleAttributeName];

	//draw the date label
	NSString * dateLabel = [[self valueForKey:@"date"] descriptionWithCalendarFormat:@"%d" timeZone:nil locale:nil];;
	overallTextSize = [dateLabel sizeWithAttributes:dateTextAttributes];
	NSRect textBounds = NSZeroRect;
	textBounds.size = NSMakeSize(width, height/2.5);

	float dateHLoc = (hCentre - overallTextSize.width/2);
	float dateVLoc = (vCentre - overallTextSize.height)/2;
	
	if ([[self valueForKey:@"isToday"] isEqual:[NSNumber numberWithBool:YES]])
	{
		[dateLabel drawAtPoint:NSMakePoint(dateHLoc,dateVLoc)
				   withAttributes:todayTextAttributes];			
	}
	else {
		
		[dateLabel drawAtPoint:NSMakePoint(dateHLoc,dateVLoc)
				withAttributes:dateTextAttributes];	
	}
	
	//draw the shadow
	[shadow setShadowColor:nil]; [shadow set]; [shadow release];	
}

// Draw a mark for a day
-(void) drawDayMark
{
	NSColor * dayMarkCol = [self dayMarkColor];
	NSBezierPath * dayMark = [NSBezierPath bezierPath];
	[dayMark moveToPoint:NSMakePoint(hCentre-1, vCentre+1)];
	[dayMark lineToPoint:NSMakePoint(hCentre-1, vCentre - 1)];
	[dayMark lineToPoint:NSMakePoint(hCentre+1, vCentre - 1)];
	[dayMark lineToPoint:NSMakePoint(hCentre+1, vCentre + 1)];
	[dayMark closePath];
	[dayMark setLineCapStyle:NSButtLineCapStyle];
	[dayMark setLineJoinStyle:NSRoundLineJoinStyle];
	[dayMarkCol set];
	[dayMark fill];
}

// Draw a diamond for today
-(void) drawTodayMarkSquare
{
	NSColor * todayMarkCol = [self todayMarkColor];
	NSBezierPath * todayMark = [NSBezierPath bezierPath];
	[todayMark moveToPoint:NSMakePoint(hCentre - 3, vCentre - 3)];
	[todayMark lineToPoint:NSMakePoint(hCentre + 3 , vCentre - 3)];
	[todayMark lineToPoint:NSMakePoint(hCentre + 3, vCentre + 3)];
	[todayMark lineToPoint:NSMakePoint(hCentre - 3, vCentre + 3)];
	[todayMark closePath];
	[todayMark setLineCapStyle:NSButtLineCapStyle];
	[todayMark setLineJoinStyle:NSRoundLineJoinStyle];
	[todayMarkCol set];
	[todayMark fill];
}

-(void) drawTodayMarkDiamond
{
	NSColor * todayMarkCol = [self todayMarkColor];
	NSBezierPath * todayMark = [NSBezierPath bezierPath];
	[todayMark moveToPoint:NSMakePoint(hCentre - 4, vCentre - 0)];
	[todayMark lineToPoint:NSMakePoint(hCentre + 0 , vCentre - 4)];
	[todayMark lineToPoint:NSMakePoint(hCentre + 4, vCentre + 0)];
	[todayMark lineToPoint:NSMakePoint(hCentre - 0, vCentre + 4)];
	[todayMark closePath];
	[todayMark setLineCapStyle:NSButtLineCapStyle];
	[todayMark setLineJoinStyle:NSRoundLineJoinStyle];
	[todayMarkCol set];
	[todayMark fill];
}

@end
