//
//  CLManagedGraphic.h
//  Periodical Engine
//
//  Created by Alex Clarke on 22/04/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*
 Graphic protocol to define methods all graphics objects must implement
 */

@protocol Graphic
- (float)xLoc;
- (void)setXLoc:(float)aXLoc;
- (float)yLoc;
- (void)setYLoc:(float)aYLoc;
- (float)width;
- (void)setWidth:(float)aWidth;
- (float)height; 
- (void)setHeight:(float)aHeight;

+ (NSArray *)keysForNonBoundsProperties;
- (NSRect)drawingBounds;
- (void)drawInView:(NSView *)aView;
- (BOOL)hitTest:(NSPoint)point isSelected:(BOOL)isSelected;
@end


@interface CLManagedGraphic : NSManagedObject <Graphic>
{
	float xLoc;
	float yLoc;
	
	float height;
	float width;	
	
	float hCentre;
	float vCentre;
	
	float shadowOffset;
	float shadowAngle; // radians	
}

@property (retain) NSData * colorData;
@property (retain) NSData * textColorData;
@property (retain) NSData * todayTextColorData;
@property (retain) NSData * todayMarkColorData;
@property (retain) NSData * dayMarkColorData;

- (float)height;
- (void)setHeight:(float)aHeight;
- (float)width;
- (void)setWidth:(float)aWidth;

- (NSColor*)color;
- (void)setColor:(NSColor*)aColor;

- (NSColor *)textColor;
- (void)setTextColor:(NSColor *)aColor;

- (NSColor *)todayTextColor;
- (void)setTodayTextColor:(NSColor *)aColor;

- (NSColor *)todayMarkColor;
- (void)setTodayMarkColor:(NSColor *)aColor;

- (NSColor *)dayMarkColor;
- (void)setDayMarkColor:(NSColor *)aColor;


- (float)shadowOffset;
- (void)setShadowOffset:(float)aShadowOffset;
- (float)shadowAngle;
- (void)setShadowAngle:(float)aShadowAngle;

- (NSRect)drawingBounds;
- (void)drawInView:(NSView *)aView;
- (BOOL)hitTest:(NSPoint)point isSelected:(BOOL)isSelected;

@end
