/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.File;
import java.util.ArrayList;
import moulserver.AuthServerSecureFiles;
import moulserver.Manager;
import shared.IBytedeque;
import shared.IBytestream;
import shared.Str;
import shared.m;
import shared.mystobj;

public class SecureDownloadManifest
extends mystobj {
    public ArrayList<Entry> entries = new ArrayList();

    public SecureDownloadManifest(IBytestream c) {
        while (true) {
            Entry entry = new Entry(c);
            if (entry.filename.toString().length() == 0) break;
            this.entries.add(entry);
        }
    }

    public SecureDownloadManifest() {
    }

    public static SecureDownloadManifest getEmptyManifest() {
        SecureDownloadManifest r = new SecureDownloadManifest();
        return r;
    }

    public static SecureDownloadManifest getManifest(String folder, String extension, Manager manager, AuthServerSecureFiles securefiles) {
        SecureDownloadManifest r = new SecureDownloadManifest();
        String path = manager.settings.getFileserverPath() + "/SecureDownload/";
        if (!folder.equals("Python") && !folder.equals("SDL")) {
            m.throwUncaughtException("Unexpected folder for SecureDownload: " + folder);
        }
        File dir = new File(path + folder);
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(extension)) continue;
            Entry entry = new Entry();
            entry.filename = new Str(folder + "\\" + file.getName());
            entry.filesize = securefiles.GetEncrypted(file.getAbsolutePath()).length;
            r.entries.add(entry);
        }
        return r;
    }

    public void write(IBytedeque c) {
        for (Entry entry : this.entries) {
            entry.write(c);
        }
        c.writeShort((short)0);
    }

    public static class Entry
    extends mystobj {
        Str filename;
        int filesize;

        public void write(IBytedeque c) {
            this.filename.writeAsUtf16NT(c);
            c.writeIntAsTwoShorts(this.filesize);
            c.writeShort((short)0);
        }

        public Entry() {
        }

        public Entry(IBytestream c) {
            this.filename = Str.readAsUtf16NT(c);
            if (this.filename.toString().length() == 0) {
                return;
            }
            this.filesize = c.readIntAsTwoShorts();
            short nt = c.readShort();
        }
    }
}

