/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.security;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.util.log.Log;

public class Password
extends Credential {
    public static final String __OBFUSCATE = "OBF:";
    private String _pw;

    public Password(String password) {
        this._pw = password;
        while (this._pw != null && this._pw.startsWith(__OBFUSCATE)) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    public boolean check(Object credentials) {
        if (this == credentials) {
            return true;
        }
        if (credentials instanceof Password) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof String) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof char[]) {
            return Arrays.equals(this._pw.toCharArray(), (char[])credentials);
        }
        if (credentials instanceof Credential) {
            return ((Credential)credentials).check(this._pw);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        if (o instanceof Password) {
            Password p = (Password)o;
            return p._pw == this._pw || null != this._pw && this._pw.equals(p._pw);
        }
        if (o instanceof String) {
            return o.equals(this._pw);
        }
        return false;
    }

    public int hashCode() {
        return null == this._pw ? super.hashCode() : this._pw.hashCode();
    }

    public static String obfuscate(String s) {
        StringBuilder buf = new StringBuilder();
        byte[] b2 = s.getBytes();
        buf.append(__OBFUSCATE);
        for (int i = 0; i < b2.length; ++i) {
            byte b1 = b2[i];
            byte b22 = b2[s.length() - (i + 1)];
            int i1 = 127 + b1 + b22;
            int i2 = 127 + b1 - b22;
            int i0 = i1 * 256 + i2;
            String x = Integer.toString(i0, 36);
            switch (x.length()) {
                case 1: {
                    buf.append('0');
                }
                case 2: {
                    buf.append('0');
                }
                case 3: {
                    buf.append('0');
                }
            }
            buf.append(x);
        }
        return buf.toString();
    }

    public static String deobfuscate(String s) {
        if (s.startsWith(__OBFUSCATE)) {
            s = s.substring(4);
        }
        byte[] b2 = new byte[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            String x = s.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            b2[l++] = (byte)((i1 + i2 - 254) / 2);
        }
        return new String(b2, 0, l);
    }

    public static Password getPassword(String realm, String dft, String promptDft) {
        String passwd = System.getProperty(realm, dft);
        if (passwd == null || passwd.length() == 0) {
            try {
                System.out.print(realm + (promptDft != null && promptDft.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] buf = new byte[512];
                int len = System.in.read(buf);
                if (len > 0) {
                    passwd = new String(buf, 0, len).trim();
                }
            }
            catch (IOException e2) {
                Log.warn("EXCEPTION ", e2);
            }
            if (passwd == null || passwd.length() == 0) {
                passwd = promptDft;
            }
        }
        return new Password(passwd);
    }

    public static void main(String[] arg) {
        if (arg.length != 1 && arg.length != 2) {
            System.err.println("Usage - java org.eclipse.jetty.security.Password [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String p = arg[arg.length == 1 ? 0 : 1];
        Password pw = new Password(p);
        System.err.println(pw.toString());
        System.err.println(Password.obfuscate(pw.toString()));
        System.err.println(Credential.MD5.digest(p));
        if (arg.length == 2) {
            System.err.println(Credential.Crypt.crypt(arg[0], pw.toString()));
        }
    }
}

