/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnDelimiters = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;
    private boolean _double = true;
    private boolean _single = true;

    public QuotedStringTokenizer(String str, String delim, boolean returnDelimiters, boolean returnQuotes) {
        super("");
        this._string = str;
        if (delim != null) {
            this._delim = delim;
        }
        this._returnDelimiters = returnDelimiters;
        this._returnQuotes = returnQuotes;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String str, String delim, boolean returnDelimiters) {
        this(str, delim, returnDelimiters, false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, false, false);
    }

    public QuotedStringTokenizer(String str) {
        this(str, null, false, false);
    }

    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int state = 0;
        boolean escape = false;
        block6: while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (state) {
                case 0: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnDelimiters) continue block6;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c) >= 0) {
                        if (this._returnDelimiters) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 2: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 3: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String t = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return t;
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this._delim = delim;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        return -1;
    }

    public static String quote(String s, String delim) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'' && !Character.isWhitespace(c) && delim.indexOf(c) < 0) continue;
            StringBuffer b2 = new StringBuffer(s.length() + 8);
            QuotedStringTokenizer.quote(b2, s);
            return b2.toString();
        }
        return s;
    }

    public static String quote(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        StringBuffer b2 = new StringBuffer(s.length() + 8);
        QuotedStringTokenizer.quote(b2, s);
        return b2.toString();
    }

    public static void quote(Appendable buf, String s) {
        try {
            char c;
            int i;
            buf.append('\"');
            block20: for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        buf.append(s, 0, i);
                        buf.append("\\\"");
                        break block20;
                    }
                    case '\\': {
                        buf.append(s, 0, i);
                        buf.append("\\\\");
                        break block20;
                    }
                    case '\n': {
                        buf.append(s, 0, i);
                        buf.append("\\n");
                        break block20;
                    }
                    case '\r': {
                        buf.append(s, 0, i);
                        buf.append("\\r");
                        break block20;
                    }
                    case '\t': {
                        buf.append(s, 0, i);
                        buf.append("\\t");
                        break block20;
                    }
                    case '\f': {
                        buf.append(s, 0, i);
                        buf.append("\\f");
                        break block20;
                    }
                    case '\b': {
                        buf.append(s, 0, i);
                        buf.append("\\b");
                        break block20;
                    }
                    default: {
                        continue block20;
                    }
                }
            }
            if (i == s.length()) {
                buf.append(s);
            } else {
                ++i;
                while (i < s.length()) {
                    c = s.charAt(i);
                    switch (c) {
                        case '\"': {
                            buf.append("\\\"");
                            break;
                        }
                        case '\\': {
                            buf.append("\\\\");
                            break;
                        }
                        case '\n': {
                            buf.append("\\n");
                            break;
                        }
                        case '\r': {
                            buf.append("\\r");
                            break;
                        }
                        case '\t': {
                            buf.append("\\t");
                            break;
                        }
                        case '\f': {
                            buf.append("\\f");
                            break;
                        }
                        case '\b': {
                            buf.append("\\b");
                            break;
                        }
                        default: {
                            buf.append(c);
                            break;
                        }
                    }
                    ++i;
                }
            }
            buf.append('\"');
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void quoteIfNeeded(Appendable buf, String s) {
        try {
            char c;
            int i;
            int e2 = -1;
            block14: for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                switch (c) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '%': 
                    case '+': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        e2 = i;
                        buf.append('\"');
                        for (int j = 0; j < e2; ++j) {
                            buf.append(s.charAt(j));
                        }
                        break block14;
                    }
                    default: {
                        continue block14;
                    }
                }
            }
            if (e2 < 0) {
                buf.append(s);
                return;
            }
            block16: for (i = e2; i < s.length(); ++i) {
                c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block16;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block16;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block16;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block16;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block16;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block16;
                    }
                    case '\b': {
                        buf.append("\\b");
                        continue block16;
                    }
                    default: {
                        buf.append(c);
                        continue block16;
                    }
                }
            }
            buf.append('\"');
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unquote(String s) {
        StringBuffer b2;
        char last;
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first != (last = s.charAt(s.length() - 1)) || first != '\"' && first != '\'') {
            return s;
        }
        StringBuffer stringBuffer = b2 = new StringBuffer(s.length() - 2);
        synchronized (stringBuffer) {
            boolean escape = false;
            for (int i = 1; i < s.length() - 1; ++i) {
                char c = s.charAt(i);
                if (escape) {
                    escape = false;
                    switch (c) {
                        case 'n': {
                            b2.append('\n');
                            break;
                        }
                        case 'r': {
                            b2.append('\r');
                            break;
                        }
                        case 't': {
                            b2.append('\t');
                            break;
                        }
                        case 'f': {
                            b2.append('\f');
                            break;
                        }
                        case 'b': {
                            b2.append('\b');
                            break;
                        }
                        case 'u': {
                            b2.append((char)((TypeUtil.convertHexDigit((byte)s.charAt(i++)) << 24) + (TypeUtil.convertHexDigit((byte)s.charAt(i++)) << 16) + (TypeUtil.convertHexDigit((byte)s.charAt(i++)) << 8) + TypeUtil.convertHexDigit((byte)s.charAt(i++))));
                            break;
                        }
                        default: {
                            b2.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                b2.append(c);
            }
            return b2.toString();
        }
    }

    public boolean getDouble() {
        return this._double;
    }

    public void setDouble(boolean d) {
        this._double = d;
    }

    public boolean getSingle() {
        return this._single;
    }

    public void setSingle(boolean single) {
        this._single = single;
    }
}

