/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.uruobj;
import shared.IBytestream;
import shared.m;
import uru.Bytedeque;
import uru.context;

public class HsBitVector
extends uruobj {
    public int count;
    int[] values;

    public HsBitVector(context c) {
        this.count = c.readInt();
        this.values = c.in.readInts(this.count);
    }

    public HsBitVector(IBytestream c) {
        this.count = c.readInt();
        this.values = c.readInts(this.count);
    }

    public HsBitVector(int ... newvalues) {
        this.count = newvalues.length;
        this.values = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.values[i] = newvalues[i];
        }
    }

    private HsBitVector() {
    }

    public static HsBitVector createWithValues(int ... newvalues) {
        HsBitVector result = new HsBitVector(newvalues);
        return result;
    }

    public static HsBitVector createDefault() {
        HsBitVector result = new HsBitVector();
        result.count = 0;
        result.values = new int[0];
        return result;
    }

    public void compile(Bytedeque data) {
        data.writeInt(this.count);
        data.writeInts(this.values);
    }

    public int get(int index) {
        if (index < this.count) {
            return this.values[index];
        }
        m.err("HsBitVector: something read out of bounds.");
        return 0;
    }

    public boolean flag(int flag) {
        int pos = flag >>> 5;
        if (pos < this.count) {
            int val = this.get(pos);
            boolean bit = (1 << (flag & 0x1F) & val) != 0;
            return bit;
        }
        return false;
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.count; ++i) {
            result = result + Integer.toHexString(this.values[i]) + ",";
        }
        return result;
    }
}

