/*
 * Decompiled with CFR 0.152.
 */
package shared;

import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class Matrix44 {
    public float[][] mat = new float[4][4];

    public static Matrix44 createFromVector(float x, float y, float z) {
        Matrix44 r = Matrix44.createIdentity();
        r.mat[0][3] = x;
        r.mat[1][3] = y;
        r.mat[2][3] = z;
        return r;
    }

    public static Matrix44 createIdentity() {
        Matrix44 r = new Matrix44();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                r.mat[i][j] = i == j ? 1.0f : 0.0f;
            }
        }
        return r;
    }

    public RealMatrix getApacheMatrix() {
        double[][] m2 = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m2[i][j] = this.mat[i][j];
            }
        }
        RealMatrixImpl m3 = new RealMatrixImpl(m2);
        return m3;
    }

    public Matrix44 getInverse() {
        RealMatrix m2 = this.getApacheMatrix();
        RealMatrix inv = m2.inverse();
        Matrix44 r = Matrix44.createFromApacheMatrix(inv);
        return r;
    }

    public static Matrix44 createFromApacheMatrix(RealMatrix m2) {
        Matrix44 r = new Matrix44();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                r.mat[i][j] = (float)m2.getEntry(i, j);
            }
        }
        return r;
    }
}

