/*
 * Decompiled with CFR 0.152.
 */
package alcugsinterface;

import alcugsinterface.LoginContext;
import alcugsinterface.PlNetAck;
import alcugsinterface.PlNetClientComm;
import shared.ByteArrayBytestream;
import shared.CryptHashes;
import shared.Int24;
import shared.b;
import shared.m;
import uru.UruCrypt;

public class Packet {
    byte id;
    byte ver;
    int checksum;
    int packetcounter;
    byte packettype;
    int zero;
    byte datafragmentcount;
    Int24 messagenum;
    byte totalNumberOfDataFragments;
    int zero2;
    byte lastFragmentedPacketAck;
    Int24 lastAckReceived;
    int dataSize;

    public Packet(byte[] packet) {
        ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(packet);
        LoginContext user = new LoginContext();
        user.isAuthenicated = false;
        this.id = c.readByte();
        if (this.id != 3) {
            m.warn("packet did not start with 3.");
            return;
        }
        this.ver = c.readByte();
        if (this.ver != 2) {
            m.warn("packer ver not equal to 2.");
            return;
        }
        this.checksum = c.readInt();
        int cs = Packet.uru_checksum(packet, user);
        if (cs != this.checksum) {
            m.warn("checksum for packet wrong.");
            return;
        }
        UruCrypt.DecryptUruMessageInPlace(packet);
        this.packetcounter = c.readInt();
        this.packettype = c.readByte();
        this.zero = c.readInt();
        this.datafragmentcount = c.readByte();
        this.messagenum = new Int24(c);
        this.totalNumberOfDataFragments = c.readByte();
        this.zero2 = c.readInt();
        this.lastFragmentedPacketAck = c.readByte();
        this.lastAckReceived = new Int24(c);
        this.dataSize = c.readInt();
        switch (this.packettype) {
            case 66: {
                m.msg("got plNetClientComm msg.");
                PlNetClientComm nc = new PlNetClientComm(c);
                break;
            }
            case -128: {
                m.msg("got ack msg.");
                PlNetAck na = new PlNetAck(c, this);
                break;
            }
            default: {
                m.msg("got unknown msg type: 0x", Integer.toHexString(this.packettype));
            }
        }
        boolean dummy = false;
    }

    public static int uru_checksum(byte[] packet, LoginContext user) {
        int i;
        int size = packet.length;
        byte[] buf = packet;
        byte[] aux_hash = user.passwordHash;
        int aux_size = size - 6;
        if (user.isAuthenicated) {
            aux_size += 32;
        }
        byte[] md5buffer = new byte[aux_size];
        for (i = 6; i < size; ++i) {
            md5buffer[i - 6] = buf[i];
        }
        if (user.isAuthenicated) {
            for (i = size; i < aux_size + 6; ++i) {
                md5buffer[i - 6] = aux_hash[i - size];
            }
        }
        byte[] hash = CryptHashes.GetMd5(md5buffer);
        int result = b.BytesToInt32(hash, 0);
        return result;
    }
}

