/*
 * Decompiled with CFR 0.152.
 */
package deepview2;

import deepview2.dvNode;
import deepview2.guiTree;
import deepview2.nodeinfo;
import java.lang.reflect.Array;

public class dvArray
extends dvNode {
    int length;

    public dvArray(nodeinfo info22) {
        this.info = info22;
        this.length = Array.getLength(this.info.obj);
    }

    public String toString() {
        return this.info.name + ": " + super.toString();
    }

    @Override
    public void loadChildren() {
        this.children.clear();
        int depth = this.length > 10000 ? 10000 : (this.length > 1000 ? 1000 : (this.length > 100 ? 100 : (this.length > 10 ? 10 : 1)));
        this.createLevels(this, depth, this.length, 0);
    }

    public Class getClass(Object obj) {
        if (obj == null) {
            return this.info.cls;
        }
        return obj.getClass();
    }

    public void createLevels(dvNode cur, int curdepth, int curlength, int curpos) {
        if (curdepth != 1) {
            int fullsets = curlength / curdepth;
            int residue = curlength % curdepth;
            int sets = fullsets + (residue == 0 ? 0 : 1);
            for (int i = 0; i < fullsets; ++i) {
                int start = curpos + i * curdepth;
                int count = curdepth;
                nodeinfo childinfo = this.info.copyinherited();
                childinfo.name = Integer.toString(start) + ".." + Integer.toString(start + count - 1);
                dvArrayCollapse newnode = new dvArrayCollapse(childinfo, this.info.obj, start, count);
                cur.children.add(newnode);
                this.createLevels(newnode, curdepth / 10, count, start);
            }
            if (residue != 0) {
                int start = curpos + fullsets * curdepth;
                int count = residue;
                nodeinfo childinfo = this.info.copyinherited();
                childinfo.name = Integer.toString(start) + ".." + Integer.toString(start + count - 1);
                dvArrayCollapse newnode = new dvArrayCollapse(childinfo, this.info.obj, start, count);
                cur.children.add(newnode);
                this.createLevels(newnode, curdepth / 10, count, start);
            }
        } else {
            for (int i = 0; i < curlength; ++i) {
                int start = curpos + i;
                nodeinfo childinfo = this.info.copyinherited();
                childinfo.name = Integer.toString(start);
                childinfo.obj = Array.get(this.info.obj, start);
                childinfo.cls = this.getClass(childinfo.obj);
                dvNode newnode = dvNode.load(childinfo);
                cur.children.add(newnode);
            }
        }
    }

    @Override
    public void onDoubleClick(guiTree tree) {
    }

    public static class dvArrayCollapse
    extends dvNode {
        public dvArrayCollapse(nodeinfo info22, Object array, int start, int count) {
            this.info = info22;
        }

        public String toString() {
            return this.info.name;
        }
    }
}

