/*
 * Decompiled with CFR 0.152.
 */
package dust.com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import sun.awt.AppContext;

public class MotifToggleButtonUI
extends BasicToggleButtonUI {
    private static final Object MOTIF_TOGGLE_BUTTON_UI_KEY = new Object();
    protected Color selectColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent b2) {
        AppContext appContext = AppContext.getAppContext();
        MotifToggleButtonUI motifToggleButtonUI = (MotifToggleButtonUI)appContext.get(MOTIF_TOGGLE_BUTTON_UI_KEY);
        if (motifToggleButtonUI == null) {
            motifToggleButtonUI = new MotifToggleButtonUI();
            appContext.put(MOTIF_TOGGLE_BUTTON_UI_KEY, motifToggleButtonUI);
        }
        return motifToggleButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        if (!this.defaults_initialized) {
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(b2, "opaque", Boolean.FALSE);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b2) {
        if (b2.isContentAreaFilled()) {
            Color oldColor = g.getColor();
            Dimension size = b2.getSize();
            Insets insets = b2.getInsets();
            Insets margin = b2.getMargin();
            if (b2.getBackground() instanceof UIResource) {
                g.setColor(this.getSelectColor());
            }
            g.fillRect(insets.left - margin.left, insets.top - margin.top, size.width - (insets.left - margin.left) - (insets.right - margin.right), size.height - (insets.top - margin.top) - (insets.bottom - margin.bottom));
            g.setColor(oldColor);
        }
    }

    public Insets getInsets(JComponent c) {
        Border border = c.getBorder();
        Insets i = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        return i;
    }
}

