/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import shared.ByteArrayBytestream;
import shared.Format;
import shared.IBytedeque;
import shared.b;
import shared.e;
import shared.m;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.context;

public class DrawableSpansEncoders {

    public static class rundataColour {
        byte basec;
        int count;
        boolean rle;

        public byte pollAsColour2(context c) {
            if (this.count == 0) {
                short out5 = c.in.readShort();
                this.count = b.Int16ToInt32(out5);
                if ((this.count & 0x8000) != 0) {
                    this.rle = true;
                    this.basec = c.in.readByte();
                    this.count &= Short.MAX_VALUE;
                } else {
                    this.rle = false;
                }
            }
            --this.count;
            if (this.rle) {
                return this.basec;
            }
            byte out6 = c.in.readByte();
            return out6;
        }

        public RawPotsColour pollAsColour(context c) {
            RawPotsColour r = new RawPotsColour();
            if (this.count == 0) {
                short out5;
                r.hadCount0 = true;
                r.out5 = out5 = c.in.readShort();
                this.count = b.Int16ToInt32(out5);
                if ((this.count & 0x8000) != 0) {
                    this.rle = true;
                    r.basec = this.basec = c.in.readByte();
                    this.count &= Short.MAX_VALUE;
                } else {
                    this.rle = false;
                }
            }
            if (this.count != 0) {
                byte out6;
                --this.count;
                r.hadRle = this.rle;
                if (this.rle) {
                    return r;
                }
                r.out6 = out6 = c.in.readByte();
                return r;
            }
            m.err("We shouldn't be able to reach here.");
            return r;
        }
    }

    public static class rundataElement {
        float basee;
        int count;
        byte b1;

        public RawPotsElement pollAsElement(context c) {
            RawPotsElement r = new RawPotsElement();
            if (this.count == 0) {
                short out7;
                r.hadcount0 = true;
                r.basee = this.basee = c.readFloat();
                if (c.readversion == 6) {
                    this.b1 = c.in.readByte();
                } else if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
                    // empty if block
                }
                r.out7 = out7 = c.in.readShort();
                this.count = b.Int16ToInt32(out7);
            }
            if (this.count != 0) {
                if (c.readversion == 6) {
                    if (this.b1 == 0) {
                        short out9;
                        --this.count;
                        r.out9 = out9 = c.in.readShort();
                    } else if (this.b1 == 1) {
                        --this.count;
                        r.out9 = 0;
                    } else {
                        m.msg("unknown byte.");
                    }
                } else if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
                    --this.count;
                    r.out9 = c.readShort();
                }
            }
            return r;
        }

        public float pollAsElement3(context c) {
            short out9 = this.pollAsElement2(c);
            float result = (float)b.Int16ToInt32(out9) / 1024.0f + this.basee;
            return result;
        }

        public float pollAsElement4(context c) {
            short out9 = this.pollAsElement2(c);
            float result = (float)b.Int16ToInt32(out9) / 32768.0f + this.basee;
            return result;
        }

        public float pollAsElement5(context c) {
            short out9 = this.pollAsElement2(c);
            float result = (float)b.Int16ToInt32(out9) / 65536.0f + this.basee;
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public short pollAsElement2(context c) {
            if (this.count == 0) {
                this.basee = c.readFloat();
                if (c.readversion == 6) {
                    this.b1 = c.in.readByte();
                } else if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
                    // empty if block
                }
                short out7 = c.in.readShort();
                this.count = b.Int16ToInt32(out7);
            }
            if (c.readversion == 6) {
                if (this.b1 == 0) {
                    --this.count;
                    return c.in.readShort();
                }
                if (this.b1 != 1) throw new uncaughtexception("unknown byte.");
                --this.count;
                return 0;
            }
            if (c.readversion != 3 && c.readversion != 4) {
                if (c.readversion != 7) throw new uncaughtexception("Unhandled readversion.");
            }
            --this.count;
            return c.readShort();
        }
    }

    public static class RawPotsColour {
        boolean hadCount0;
        short out5;
        boolean hadRle;
        byte basec;
        byte out6;

        public static RawPotsColour createSingleton(byte val) {
            RawPotsColour r = new RawPotsColour();
            r.hadCount0 = true;
            r.out5 = 1;
            r.hadRle = false;
            r.out6 = val;
            return r;
        }

        public void compile(IBytedeque c) {
            if (this.hadCount0) {
                c.writeShort(this.out5);
                if (this.hadRle) {
                    c.writeByte(this.basec);
                }
            }
            if (!this.hadRle) {
                c.writeByte(this.out6);
            }
        }
    }

    public static class RawPotsElement {
        boolean hadcount0;
        float basee;
        short out7;
        short out9;

        public static RawPotsElement createSingleton(float val) {
            RawPotsElement r = new RawPotsElement();
            r.hadcount0 = true;
            r.basee = val;
            r.out7 = 1;
            r.out9 = 0;
            return r;
        }

        public void doubleval() {
        }

        public void compile(IBytedeque c) {
            if (this.hadcount0) {
                c.writeFloat(this.basee);
                c.writeShort(this.out7);
            }
            c.writeShort(this.out9);
        }
    }

    public static class RawPotsVertex {
        RawPotsElement x;
        RawPotsElement y;
        RawPotsElement z;
        RawPotsElement[] ws;
        Integer bones;
        short normx;
        short normy;
        short normz;
        RawPotsColour blue;
        RawPotsColour green;
        RawPotsColour red;
        RawPotsColour alpha;
        public RawPotsElement[][] uvs;

        public void compile(Bytedeque c) {
            this.x.compile(c);
            this.y.compile(c);
            this.z.compile(c);
            for (RawPotsElement rpe : this.ws) {
                rpe.compile(c);
            }
            if (this.bones != null) {
                c.writeInt(this.bones);
            }
            c.writeShort(this.normx);
            c.writeShort(this.normy);
            c.writeShort(this.normz);
            this.blue.compile(c);
            this.green.compile(c);
            this.red.compile(c);
            this.alpha.compile(c);
            RawPotsElement[] rawPotsElementArray = this.uvs;
            int n = rawPotsElementArray.length;
            for (int i = 0; i < n; ++i) {
                RawPotsElement rpes;
                for (RawPotsElement rpe : rpes = rawPotsElementArray[i]) {
                    rpe.compile(c);
                }
            }
        }
    }

    public static class PotsColourEncoder {
        byte[] vals;
        int i = 0;
        int curRunLength = 0;
        boolean homogenous;
        byte homogenousBasis;

        public PotsColourEncoder(byte[] newvals) {
            this.vals = newvals;
        }

        public void compileNext(Bytedeque c) {
            if (this.curRunLength == 0) {
                this.lookahead();
                if (this.homogenous) {
                    short out = (short)(this.curRunLength | 0x8000);
                    c.writeShort(out);
                    c.writeByte(this.homogenousBasis);
                } else {
                    short out = (short)this.curRunLength;
                    c.writeShort(out);
                }
            }
            if (!this.homogenous) {
                c.writeByte(this.vals[this.i]);
            }
            --this.curRunLength;
            ++this.i;
        }

        void lookahead() {
            this.curRunLength = 1;
            int numRemaining = this.vals.length - this.i;
            if (numRemaining < 4) {
                this.homogenous = false;
                this.curRunLength = numRemaining;
                return;
            }
            this.homogenousBasis = this.vals[this.i];
            if (this.homogenousBasis == this.vals[this.i + 1] && this.homogenousBasis == this.vals[this.i + 2] && this.homogenousBasis == this.vals[this.i + 3]) {
                this.homogenous = true;
                for (int j = this.i + 1; j < this.vals.length; ++j) {
                    if (this.curRunLength == Short.MAX_VALUE) {
                        return;
                    }
                    byte curval = this.vals[j];
                    if (curval != this.homogenousBasis) {
                        return;
                    }
                    ++this.curRunLength;
                }
                return;
            }
            for (int j = this.i + 1; j < this.vals.length - 4; ++j) {
                int testCurRunLength = j - this.i;
                if (testCurRunLength == Short.MAX_VALUE) {
                    this.homogenous = false;
                    this.curRunLength = testCurRunLength;
                    return;
                }
                byte curval = this.vals[j];
                if (curval != this.vals[j + 1] || curval != this.vals[j + 2] || curval != this.vals[j + 3]) continue;
                this.homogenous = false;
                this.curRunLength = testCurRunLength;
                return;
            }
            this.homogenous = false;
            this.curRunLength = numRemaining;
        }
    }

    public static class PotsElementEncoder {
        float[] vals;
        float divisor;
        int i = 0;
        float range;
        float min;
        int curRunLength = 0;

        public PotsElementEncoder(float[] _vals, float _divisor) {
            this.vals = _vals;
            this.divisor = _divisor;
            this.range = 65536.0f / this.divisor;
        }

        public void compileNext(Bytedeque c) {
            if (this.curRunLength == 0) {
                this.lookahead();
                c.writeFloat(this.min);
                short l = (short)this.curRunLength;
                c.writeShort(l);
            }
            short out = (short)((this.vals[this.i] - this.min) * this.divisor + 0.5f);
            c.writeShort(out);
            --this.curRunLength;
            ++this.i;
        }

        void lookahead() {
            float max = this.min = (float)Math.floor(this.vals[this.i] * this.divisor + 0.5f) / this.divisor;
            this.curRunLength = 1;
            for (int j = this.i + 1; j < this.vals.length; ++j) {
                if (this.curRunLength == 65535) {
                    return;
                }
                float curval = (float)Math.floor(this.vals[j] * this.divisor + 0.5f) / this.divisor;
                if (curval < this.min) {
                    if (max - curval < this.range) {
                        this.min = curval;
                        ++this.curRunLength;
                        continue;
                    }
                    return;
                }
                if (!(curval > max)) continue;
                if (curval - this.min < this.range) {
                    max = curval;
                    ++this.curRunLength;
                    continue;
                }
                return;
            }
        }
    }

    public static class DecompressedPotsVertices {
        public int count;
        public int A;
        public int B;
        public int C;
        public float[] xs;
        public float[] ys;
        public float[] zs;
        public float[][] wss;
        public int[] bones;
        public short[] normxs;
        public short[] normys;
        public short[] normzs;
        public byte[] blues;
        public byte[] greens;
        public byte[] reds;
        public byte[] alphas;
        public float[][][] uvss;

        public DecompressedPotsVertices(byte[] rawdata, byte fformat2, int rawdataversion, int count2) {
            int j;
            int i;
            this.count = count2;
            context c = context.createFromBytestream(ByteArrayBytestream.createFromByteArray(rawdata));
            e.force(rawdataversion == 3);
            c.readversion = rawdataversion;
            int fformat = b.ByteToInt32(fformat2);
            this.A = (fformat & 0x40) >>> 6;
            this.B = (fformat & 0x30) >>> 4;
            this.C = (fformat & 0xF) >>> 0;
            rundataElement x = new rundataElement();
            rundataElement y = new rundataElement();
            rundataElement z = new rundataElement();
            rundataElement[] ws = new rundataElement[this.B];
            for (int i2 = 0; i2 < this.B; ++i2) {
                ws[i2] = new rundataElement();
            }
            rundataColour blue = new rundataColour();
            rundataColour green = new rundataColour();
            rundataColour red = new rundataColour();
            rundataColour alpha = new rundataColour();
            rundataElement[][] uvs = new rundataElement[this.C][3];
            for (i = 0; i < this.C; ++i) {
                for (j = 0; j < 3; ++j) {
                    uvs[i][j] = new rundataElement();
                }
            }
            this.initArrays();
            for (i = 0; i < count2; ++i) {
                this.xs[i] = x.pollAsElement3(c);
                this.ys[i] = y.pollAsElement3(c);
                this.zs[i] = z.pollAsElement3(c);
                for (j = 0; j < this.B; ++j) {
                    this.wss[j][i] = ws[j].pollAsElement4(c);
                }
                if (this.B != 0 && this.A != 0) {
                    this.bones[i] = c.in.readInt();
                }
                this.normxs[i] = c.in.readShort();
                this.normys[i] = c.in.readShort();
                this.normzs[i] = c.in.readShort();
                this.blues[i] = blue.pollAsColour2(c);
                this.greens[i] = green.pollAsColour2(c);
                this.reds[i] = red.pollAsColour2(c);
                this.alphas[i] = alpha.pollAsColour2(c);
                for (j = 0; j < this.C; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        this.uvss[j][k][i] = uvs[j][k].pollAsElement5(c);
                    }
                }
            }
            if (c.in.getBytesRemaining() != 0) {
                boolean bl = false;
            }
        }

        DecompressedPotsVertices() {
        }

        public static DecompressedPotsVertices createEmpty() {
            DecompressedPotsVertices r = new DecompressedPotsVertices();
            return r;
        }

        public byte[] compileall() {
            Bytedeque c = new Bytedeque(Format.pots);
            this.compileSophisticated(c);
            byte[] r = c.getAllBytes();
            return r;
        }

        public void initArrays() {
            this.xs = new float[this.count];
            this.ys = new float[this.count];
            this.zs = new float[this.count];
            if (this.B != 0) {
                this.wss = new float[this.B][this.count];
            }
            if (this.B != 0 && this.A != 0) {
                this.bones = new int[this.count];
            }
            this.normxs = new short[this.count];
            this.normys = new short[this.count];
            this.normzs = new short[this.count];
            this.blues = new byte[this.count];
            this.greens = new byte[this.count];
            this.reds = new byte[this.count];
            this.alphas = new byte[this.count];
            if (this.C != 0) {
                this.uvss = new float[this.C][3][this.count];
            }
        }

        public byte getfformat() {
            int fformat2 = this.A << 6 | this.B << 4 | this.C << 0;
            byte fformat = (byte)(0x80 | fformat2);
            return fformat;
        }

        public void compileSophisticated(Bytedeque c) {
            int j;
            int i;
            PotsElementEncoder x = new PotsElementEncoder(this.xs, 1024.0f);
            PotsElementEncoder y = new PotsElementEncoder(this.ys, 1024.0f);
            PotsElementEncoder z = new PotsElementEncoder(this.zs, 1024.0f);
            PotsElementEncoder[] ws = new PotsElementEncoder[this.B];
            for (int i2 = 0; i2 < this.B; ++i2) {
                ws[i2] = new PotsElementEncoder(this.wss[i2], 32768.0f);
            }
            PotsColourEncoder blue = new PotsColourEncoder(this.blues);
            PotsColourEncoder green = new PotsColourEncoder(this.greens);
            PotsColourEncoder red = new PotsColourEncoder(this.reds);
            PotsColourEncoder alpha = new PotsColourEncoder(this.alphas);
            PotsElementEncoder[][] uvs = new PotsElementEncoder[this.C][3];
            for (i = 0; i < this.C; ++i) {
                for (j = 0; j < 3; ++j) {
                    uvs[i][j] = new PotsElementEncoder(this.uvss[i][j], 65536.0f);
                }
            }
            for (i = 0; i < this.count; ++i) {
                x.compileNext(c);
                y.compileNext(c);
                z.compileNext(c);
                if (this.wss != null) {
                    for (j = 0; j < this.B; ++j) {
                        ws[j].compileNext(c);
                    }
                }
                if (this.bones != null) {
                    c.writeInt(this.bones[i]);
                }
                c.writeShort(this.normxs[i]);
                c.writeShort(this.normys[i]);
                c.writeShort(this.normzs[i]);
                blue.compileNext(c);
                green.compileNext(c);
                red.compileNext(c);
                alpha.compileNext(c);
                if (this.uvss == null) continue;
                for (j = 0; j < this.C; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        uvs[j][k].compileNext(c);
                    }
                }
            }
        }

        public void compileNaive(Bytedeque c) {
            for (int i = 0; i < this.count; ++i) {
                int j;
                RawPotsElement.createSingleton(this.xs[i]).compile(c);
                RawPotsElement.createSingleton(this.ys[i]).compile(c);
                RawPotsElement.createSingleton(this.zs[i]).compile(c);
                if (this.wss != null) {
                    for (j = 0; j < this.wss.length; ++j) {
                        RawPotsElement.createSingleton(this.wss[j][i]).compile(c);
                    }
                }
                if (this.bones != null) {
                    c.writeInt(this.bones[i]);
                }
                c.writeShort(this.normxs[i]);
                c.writeShort(this.normys[i]);
                c.writeShort(this.normzs[i]);
                RawPotsColour.createSingleton(this.blues[i]).compile(c);
                RawPotsColour.createSingleton(this.greens[i]).compile(c);
                RawPotsColour.createSingleton(this.reds[i]).compile(c);
                RawPotsColour.createSingleton(this.alphas[i]).compile(c);
                if (this.uvss == null) continue;
                for (j = 0; j < this.uvss.length; ++j) {
                    for (int k = 0; k < this.uvss[j].length; ++k) {
                        RawPotsElement.createSingleton(this.uvss[j][k][i]).compile(c);
                    }
                }
            }
        }
    }

    public static class RawPotsVertices {
        public RawPotsVertex[] vertices;

        public RawPotsVertices(int count) {
            this.vertices = new RawPotsVertex[count];
        }

        public byte[] compileall() {
            Bytedeque c = new Bytedeque(Format.pots);
            for (RawPotsVertex v : this.vertices) {
                v.compile(c);
            }
            byte[] r = c.getAllBytes();
            return r;
        }
    }
}

