/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import shared.FileUtils;
import shared.GetResource;
import shared.GuiUtils_TextDialog;
import shared.m;
import shared.translation;

public class GuiUtils {
    public static final boolean onlyUseASingleJFileChooser = true;
    private static JFileChooser _fc;
    private static TrayIcon _trayicon;

    public static void DisplayMessage(String caption, String message) {
        GuiUtils_TextDialog.showMessageDialog(caption, message);
    }

    public static void DisplayTrayMessage(String caption, String message) {
        if (_trayicon == null) {
            m.err("You must have shown the tray icon first.");
        } else {
            _trayicon.displayMessage(caption, message, TrayIcon.MessageType.NONE);
        }
    }

    public static void showTrayIcon(String imgpath) {
        try {
            TrayIcon ti;
            if (_trayicon != null) {
                return;
            }
            SystemTray tray = SystemTray.getSystemTray();
            Image img = GetResource.getResourceAsImage(imgpath);
            _trayicon = ti = new TrayIcon(img);
            ti.setImageAutoSize(true);
            tray.add(ti);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void printUIManagerResources() {
        for (Object key : UIManager.getDefaults().keySet()) {
            m.msg(key.toString());
        }
    }

    public static void setBackgroundColour(Color colour) {
        ColorUIResource res = new ColorUIResource(colour);
        UIManager.put("Panel.background", res);
        UIManager.put("Button.background", res);
        UIManager.put("TextArea.background", res);
        UIManager.put("RadioButton.background", res);
        UIManager.put("CheckBox.background", res);
        UIManager.put("TextField.background", res);
        UIManager.put("TabbedPane.background", res);
        UIManager.put("TextPane.background", res);
    }

    public static void updateGui(final Component c, boolean immediate) {
        if (immediate) {
            SwingUtilities.updateComponentTreeUI(c);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.updateComponentTreeUI(c);
                }
            });
        }
    }

    public static void setCrossPlatformFonts(boolean tryToUseFixedWidth) {
        FontUIResource fixed;
        FontUIResource plain = new FontUIResource("Lucida Sans", 0, 12);
        if (tryToUseFixedWidth) {
            String fixedstr = "Lucida Sans Typewriter";
            boolean hasfixed = false;
            for (String s : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!s.equals(fixedstr)) continue;
                hasfixed = true;
                break;
            }
            fixed = hasfixed ? new FontUIResource(fixedstr, 0, 12) : new FontUIResource("Monospaced", 0, 12);
        } else {
            fixed = plain;
        }
        UIManager.put("Button.font", plain);
        UIManager.put("ToggleButton.font", plain);
        UIManager.put("RadioButton.font", plain);
        UIManager.put("CheckBox.font", plain);
        UIManager.put("ColorChooser.font", plain);
        UIManager.put("ComboBox.font", plain);
        UIManager.put("Label.font", plain);
        UIManager.put("MenuBar.font", plain);
        UIManager.put("MenuItem.font", plain);
        UIManager.put("RadioButtonMenuItem.font", plain);
        UIManager.put("CheckBoxMenuItem.font", plain);
        UIManager.put("Menu.font", plain);
        UIManager.put("PopupMenu.font", plain);
        UIManager.put("OptionPane.font", plain);
        UIManager.put("Panel.font", plain);
        UIManager.put("ProgressBar.font", plain);
        UIManager.put("ScrollPane.font", plain);
        UIManager.put("Viewport.font", plain);
        UIManager.put("TabbedPane.font", plain);
        UIManager.put("Table.font", plain);
        UIManager.put("TableHeader.font", plain);
        UIManager.put("TitledBorder.font", plain);
        UIManager.put("ToolBar.font", plain);
        UIManager.put("ToolTip.font", plain);
        UIManager.put("Tree.font", plain);
        UIManager.put("TextField.font", plain);
        UIManager.put("PasswordField.font", plain);
        UIManager.put("TextArea.font", fixed);
        UIManager.put("TextPane.font", fixed);
        UIManager.put("EditorPane.font", plain);
    }

    public static JFileChooser getJFileChooser() {
        if (_fc == null) {
            _fc = CustomJFileChooser.getInstance();
        }
        return _fc;
    }

    public static boolean getOKorCancelFromUserDos(String message, String title) {
        JFrame fr = new JFrame();
        fr.setState(1);
        fr.show();
        int r = JOptionPane.showConfirmDialog(null, message, title, 2, -1);
        fr.hide();
        return r == 0;
    }

    public static boolean getOKorCancelFromUser(String message, String title) {
        int r = JOptionPane.showConfirmDialog(null, message, title, 2, -1);
        return r == 0;
    }

    public static void getStringFromUser(JTextComponent field, String message, String title) {
        String result = JOptionPane.showInputDialog(null, translation.translate(message), translation.translate(title), -1);
        if (result != null) {
            field.setText(result);
        }
    }

    public static String getStringFromUser(String message, String title) {
        String result = JOptionPane.showInputDialog(null, translation.translate(message), translation.translate(title), -1);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static void getUserSelectedFolder(JTextComponent field) {
        JFileChooser fc = GuiUtils.getJFileChooser();
        File f = new File(field.getText());
        File cwd = f.isDirectory() ? f : f.getParentFile();
        fc.setCurrentDirectory(cwd);
        fc.setFileSelectionMode(1);
        int wasFileChosen = fc.showOpenDialog(null);
        if (wasFileChosen == 0) {
            String file = fc.getSelectedFile().getAbsolutePath();
            field.setText(file);
        }
    }

    public static void getUserSelectedFile(JTextComponent field) {
        String filename = GuiUtils.getUserSelectedFile(field.getText());
        if (filename != null) {
            field.setText(filename);
        }
    }

    public static String getUserSelectedFile(String defaultFolder) {
        return GuiUtils.getUserSelected(defaultFolder, 0);
    }

    private static String getUserSelected(String defaultFolder, int selectionMode) {
        JFileChooser fc = GuiUtils.getJFileChooser();
        File f = new File(defaultFolder);
        File cwd = f.isDirectory() ? f : f.getParentFile();
        fc.setCurrentDirectory(cwd);
        fc.setFileSelectionMode(selectionMode);
        int wasFileChosen = fc.showOpenDialog(null);
        if (wasFileChosen == 0) {
            String file = fc.getSelectedFile().getAbsolutePath();
            return file;
        }
        return null;
    }

    public static void getUserSelectedFileWithNoPath(JTextComponent field) {
        JFileChooser fc = GuiUtils.getJFileChooser();
        File f = new File(field.getText());
        File cwd = f.isDirectory() ? f : f.getParentFile();
        fc.setCurrentDirectory(cwd);
        fc.setFileSelectionMode(0);
        int wasFileChosen = fc.showOpenDialog(null);
        if (wasFileChosen == 0) {
            String file = fc.getSelectedFile().getName();
            field.setText(file);
        }
    }

    public static void getUserSelectedFileOrFolder(JTextComponent field) {
        JFileChooser fc = GuiUtils.getJFileChooser();
        File f = new File(field.getText());
        File cwd = f.isDirectory() ? f : f.getParentFile();
        fc.setCurrentDirectory(cwd);
        fc.setFileSelectionMode(2);
        int wasFileChosen = fc.showOpenDialog(null);
        if (wasFileChosen == 0) {
            String file = fc.getSelectedFile().getAbsolutePath();
            field.setText(file);
        }
    }

    public static void SetKeymaps() {
        GuiUtils.SetKeymap(new JTextField());
        GuiUtils.SetKeymap(new JTextArea());
        GuiUtils.SetKeymap(new JFormattedTextField());
    }

    public static void SetKeymap(JTextComponent componentExample) {
        Keymap keymap = componentExample.getKeymap();
        ActionMap actionmap = componentExample.getActionMap();
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 128), new DefaultEditorKit.CopyAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 128), new DefaultEditorKit.PasteAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 128), new DefaultEditorKit.CutAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 64), new DefaultEditorKit.PasteAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 128), actionmap.get("select-all"));
    }

    static class CustomJFileChooser
    extends JFileChooser {
        JPanel drivePanel;

        private void addDriveButton(String label, final File file) {
            JButton jb = new JButton(label);
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    CustomJFileChooser.this.updateroot(file);
                }
            });
            this.drivePanel.add(jb);
        }

        @Override
        public void rescanCurrentDirectory() {
            this.drivePanel.removeAll();
            this.addDriveButton("Desktop", FileSystemView.getFileSystemView().getHomeDirectory());
            for (File root : File.listRoots()) {
                this.addDriveButton(root.toString(), root);
            }
            this.drivePanel.revalidate();
            super.rescanCurrentDirectory();
        }

        static CustomJFileChooser getInstance() {
            UIManager.put("FileChooser.helpButtonText", "Help");
            UIManager.put("FileChooser.openButtonText", "OK");
            UIManager.put("FileChooser.updateButtonText", "Update");
            UIManager.put("FileChooser.cancelButtonText", "Cancel");
            UIManager.put("FileChooser.pathLabelText", "Enter path or folder name:");
            UIManager.put("FileChooser.filterLabelText", "Filter");
            UIManager.put("FileChooser.acceptAllFileFilterText", "*");
            UIManager.put("FileChooser.enterFileNameLabelText", "Enter file name:");
            UIManager.put("FileChooser.filesLabelText", "Files");
            UIManager.put("FileChooser.foldersLabelText", "Folders");
            return new CustomJFileChooser();
        }

        private CustomJFileChooser() {
            this.setPreferredSize(new Dimension(700, 500));
            this.setDialogTitle("Select...");
            LayoutManager lm = this.getLayout();
            GridLayout gl = new GridLayout(0, 1);
            this.drivePanel = new JPanel(gl);
            this.addImpl(this.drivePanel, "West", -1);
            JPanel pan2 = new JPanel();
            JButton createfolderbutton = new JButton("Create Folder");
            final CustomJFileChooser ths = this;
            createfolderbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    String newfol = GuiUtils.getStringFromUser("Folder Name:", "Create Folder");
                    if (newfol.equals("")) {
                        return;
                    }
                    String fullnew = ths.getCurrentDirectory().getAbsolutePath() + "/" + newfol;
                    FileUtils.CreateFolder(fullnew);
                    ths.rescanCurrentDirectory();
                }
            });
            BoxLayout gl2 = new BoxLayout(pan2, 1);
            pan2.add(Box.createGlue());
            pan2.add(createfolderbutton);
            this.addImpl(pan2, "East", -1);
            translation.registerGUIForm(this);
        }

        public void updateroot(File dir) {
            this.setCurrentDirectory(dir);
        }

        static class Root {
            String display;
            File dir;

            public Root(String display, File dir) {
                this.display = display;
                this.dir = dir;
            }

            public String toString() {
                return this.display;
            }
        }
    }
}

