/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class QuadStateCheckBox
extends JCheckBox {
    private final transient QuadStateDecorator cbModel;
    private final State[] allowed;
    private final transient MouseListener mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.cbModel.nextState();
            }
        }
    };

    public QuadStateCheckBox(String text, Icon icon, State initial, State ... allowed) {
        super(text, icon);
        this.allowed = Utils.copyArray(allowed);
        super.addMouseListener(this.mouseAdapter);
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.cbModel.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.cbModel = new QuadStateDecorator(this.getModel());
        this.setModel(this.cbModel);
        this.setState(initial);
    }

    public QuadStateCheckBox(String text, State initial, State ... allowed) {
        this(text, (Icon)null, initial, allowed);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
    }

    public MouseListener getMouseAdapter() {
        return this.mouseAdapter;
    }

    public final void setPropertyText(String propertyText) {
        this.cbModel.setPropertyText(propertyText);
    }

    public final void setState(State state) {
        this.cbModel.setState(state);
    }

    public State getState() {
        return this.cbModel.getState();
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setState(State.SELECTED);
        } else {
            this.setState(State.NOT_SELECTED);
        }
    }

    public static enum State {
        NOT_SELECTED,
        SELECTED,
        UNSET,
        PARTIAL;

    }

    private final class QuadStateDecorator
    implements ButtonModel {
        private final ButtonModel other;
        private String propertyText;

        private QuadStateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == State.NOT_SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("false: the property is explicitly switched off", new Object[0]) : I18n.tr("false: the property ''{0}'' is explicitly switched off", this.propertyText));
            } else if (state == State.SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("true: the property is explicitly switched on", new Object[0]) : I18n.tr("true: the property ''{0}'' is explicitly switched on", this.propertyText));
            } else if (state == State.PARTIAL) {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("partial: different selected objects have different values, do not change", new Object[0]) : I18n.tr("partial: different selected objects have different values for ''{0}'', do not change", this.propertyText));
            } else {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("unset: do not set this property on the selected objects", new Object[0]) : I18n.tr("unset: do not set the property ''{0}'' on the selected objects", this.propertyText));
            }
        }

        private void setPropertyText(String propertyText) {
            this.propertyText = propertyText;
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return State.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return State.PARTIAL;
            }
            if (!this.isSelected() && !this.isArmed()) {
                return State.NOT_SELECTED;
            }
            return State.UNSET;
        }

        private void nextState() {
            State current = this.getState();
            IntStream.range(0, QuadStateCheckBox.this.allowed.length).filter(i -> QuadStateCheckBox.this.allowed[i] == current).findFirst().ifPresent(i -> this.setState(i == QuadStateCheckBox.this.allowed.length - 1 ? QuadStateCheckBox.this.allowed[0] : QuadStateCheckBox.this.allowed[i + 1]));
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setSelected(boolean b) {
        }

        @Override
        public void setPressed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            QuadStateCheckBox.this.setFocusable(b);
            if (this.other != null) {
                this.other.setEnabled(b);
            }
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

