/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.io.File;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class SourceEntry {
    public final SourceType type;
    public String url;
    public boolean isZip;
    public String zipEntryPath;
    public String name;
    public String title;
    public boolean active;

    public SourceEntry(SourceType type, String url, boolean isZip, String zipEntryPath, String name, String title, boolean active) {
        this.type = type;
        this.url = url;
        this.isZip = isZip;
        this.zipEntryPath = "".equals(zipEntryPath) ? null : zipEntryPath;
        this.name = "".equals(name) ? null : name;
        this.title = "".equals(title) ? null : title;
        this.active = active;
    }

    public SourceEntry(SourceType type, String url, String name, String title, boolean active) {
        this(type, url, false, null, name, title, active);
    }

    public SourceEntry(SourceEntry e) {
        this.type = e.type;
        this.url = e.url;
        this.isZip = e.isZip;
        this.zipEntryPath = e.zipEntryPath;
        this.name = e.name;
        this.title = e.title;
        this.active = e.active;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceEntry that = (SourceEntry)obj;
        return this.isZip == that.isZip && this.active == that.active && Objects.equals(this.url, that.url) && Objects.equals(this.zipEntryPath, that.zipEntryPath) && Objects.equals(this.name, that.name) && Objects.equals(this.title, that.title);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.isZip, this.zipEntryPath, this.name, this.title, this.active);
    }

    public String toString() {
        return this.title != null ? this.title : this.url;
    }

    public String getDisplayString() {
        if (this.title != null) {
            return this.title;
        }
        return this.getFileNamePart();
    }

    public String getFileNamePart() {
        Pattern p = Pattern.compile("([^/\\\\]*?)([?].*)?$");
        Matcher m = p.matcher(this.url);
        if (m.find()) {
            return m.group(1);
        }
        Logging.warn("Unexpected URL format: " + this.url);
        return this.url;
    }

    public String getPrefName() {
        return this.name == null ? "standard" : this.name;
    }

    public boolean isLocal() {
        return Utils.isLocalUrl(this.url);
    }

    public File getLocalSourceDir() {
        if (!this.isLocal()) {
            return null;
        }
        return new File(this.url).getParentFile();
    }

    public String getZipEntryDirName() {
        if (this.zipEntryPath == null) {
            return null;
        }
        File file = new File(this.zipEntryPath);
        File dir = file.getParentFile();
        if (dir == null) {
            return ".";
        }
        String path = dir.getPath();
        if (!"/".equals(File.separator)) {
            path = path.replace(File.separator, "/");
        }
        return path;
    }
}

