/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox.style;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.Expression;

public class Layers {
    private static final String EMPTY_STRING = "";
    private static final char SEMI_COLON = ';';
    private static final Pattern CURLY_BRACES = Pattern.compile("(\\{(.*?)})");
    private static final String PAINT = "paint";
    private final String id;
    private final Type type;
    private final Expression filter;
    private final int maxZoom;
    private final int minZoom;
    private final String paint;
    private final String source;
    private final String sourceLayer;
    private final String styleId;

    public Layers(JsonObject layerInfo) {
        this(null, layerInfo);
    }

    public Layers(String styleId, JsonObject layerInfo) {
        this.id = layerInfo.getString("id");
        this.styleId = styleId;
        this.type = Type.valueOf(layerInfo.getString("type").replace("-", "_").toUpperCase(Locale.ROOT));
        this.filter = layerInfo.containsKey("filter") ? new Expression((JsonValue)layerInfo.get("filter")) : Expression.EMPTY_EXPRESSION;
        this.maxZoom = layerInfo.getInt("maxzoom", Integer.MAX_VALUE);
        this.minZoom = layerInfo.getInt("minzoom", Integer.MIN_VALUE);
        this.source = this.type == Type.BACKGROUND ? layerInfo.getString("source", null) : layerInfo.getString("source");
        if (layerInfo.containsKey(PAINT) && ((JsonValue)layerInfo.get(PAINT)).getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject paintObject = layerInfo.getJsonObject(PAINT);
            JsonObject layoutObject = ((JsonValue)layerInfo.getOrDefault("layout", JsonValue.EMPTY_JSON_OBJECT)).asJsonObject();
            if ("visible".equalsIgnoreCase(layoutObject.getString("visibility", "visible"))) {
                switch (this.type) {
                    case FILL: {
                        this.paint = Layers.parsePaintFill(paintObject);
                        break;
                    }
                    case LINE: {
                        this.paint = Layers.parsePaintLine(layoutObject, paintObject);
                        break;
                    }
                    case CIRCLE: {
                        this.paint = Layers.parsePaintCircle(paintObject);
                        break;
                    }
                    case SYMBOL: {
                        this.paint = this.parsePaintSymbol(layoutObject, paintObject);
                        break;
                    }
                    case BACKGROUND: {
                        this.paint = Layers.parsePaintBackground(paintObject);
                        break;
                    }
                    default: {
                        this.paint = EMPTY_STRING;
                        break;
                    }
                }
            } else {
                this.paint = EMPTY_STRING;
            }
        } else {
            this.paint = EMPTY_STRING;
        }
        this.sourceLayer = layerInfo.getString("source-layer", null);
    }

    public Expression getFilter() {
        return this.filter;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    private static String parsePaintLine(JsonObject layoutObject, JsonObject paintObject) {
        StringBuilder sb = new StringBuilder(36);
        String color = paintObject.getString("line-color", "#000000");
        sb.append("color").append(':').append(color).append(';');
        JsonNumber opacity = paintObject.getJsonNumber("line-opacity");
        if (opacity != null) {
            sb.append("opacity").append(':').append(opacity.numberValue().doubleValue()).append(';');
        }
        String cap = layoutObject.getString("line-cap", "butt");
        sb.append("linecap").append(':');
        switch (cap) {
            case "round": 
            case "square": {
                sb.append(cap);
                break;
            }
            default: {
                sb.append("none");
            }
        }
        sb.append(';');
        if (paintObject.containsKey("line-dasharray")) {
            JsonArray dashArray = paintObject.getJsonArray("line-dasharray");
            sb.append("dashes").append(':');
            sb.append(dashArray.stream().filter(JsonNumber.class::isInstance).map(JsonNumber.class::cast).map(JsonNumber::toString).collect(Collectors.joining(",")));
            sb.append(';');
        }
        JsonNumber width = paintObject.getJsonNumber("line-width");
        sb.append("width").append(':').append(width == null ? Integer.valueOf(1) : width.toString()).append(';');
        return sb.toString();
    }

    private static String parsePaintCircle(JsonObject paintObject) {
        StringBuilder sb = new StringBuilder(150).append("symbol-shape:circle;").append("symbol-fill-color:").append(paintObject.getString("circle-color", "#000000")).append(';');
        JsonNumber fillOpacity = paintObject.getJsonNumber("circle-opacity");
        sb.append("symbol-fill-opacity:").append(fillOpacity != null ? fillOpacity.numberValue().toString() : "1").append(';');
        JsonNumber radius = paintObject.getJsonNumber("circle-radius");
        sb.append("symbol-size:").append(radius != null ? Double.valueOf(2.0 * radius.numberValue().doubleValue()) : "10").append(';').append("symbol-stroke-color:").append(paintObject.getString("circle-stroke-color", "#000000")).append(';');
        JsonNumber strokeOpacity = paintObject.getJsonNumber("circle-stroke-opacity");
        sb.append("symbol-stroke-opacity:").append(strokeOpacity != null ? strokeOpacity.numberValue().toString() : "1").append(';');
        JsonNumber strokeWidth = paintObject.getJsonNumber("circle-stroke-width");
        sb.append("symbol-stroke-width:").append(strokeWidth != null ? strokeWidth.numberValue().toString() : "0").append(';');
        return sb.toString();
    }

    private String parsePaintSymbol(JsonObject layoutObject, JsonObject paintObject) {
        List<JsonNumber> offset;
        StringBuilder sb = new StringBuilder();
        boolean iconImage = false;
        if (layoutObject.containsKey("icon-image")) {
            int previousMatch;
            sb.append("icon-image:concat(");
            if (this.styleId != null && !this.styleId.trim().isEmpty()) {
                sb.append('\"').append(this.styleId).append('/').append("\",");
            }
            Matcher matcher = CURLY_BRACES.matcher(layoutObject.getString("icon-image"));
            StringBuffer stringBuffer = new StringBuffer();
            if (matcher.lookingAt()) {
                matcher.appendReplacement(stringBuffer, "tag(\"$2\"),\"");
                previousMatch = matcher.end();
            } else {
                previousMatch = 0;
                stringBuffer.append('\"');
            }
            while (matcher.find()) {
                if (matcher.start() == previousMatch) {
                    matcher.appendReplacement(stringBuffer, ",tag(\"$2\")");
                } else {
                    matcher.appendReplacement(stringBuffer, "\",tag(\"$2\"),\"");
                }
                previousMatch = matcher.end();
            }
            if (matcher.hitEnd() && stringBuffer.toString().endsWith(",\"")) {
                stringBuffer.delete(stringBuffer.length() - ",\"".length(), stringBuffer.length());
            } else if (!matcher.hitEnd()) {
                stringBuffer.append('\"');
            }
            StringBuffer tail = new StringBuffer();
            matcher.appendTail(tail);
            if (tail.length() > 0) {
                String current = stringBuffer.toString();
                if (!"\"".equals(current) && !current.endsWith(",\"")) {
                    stringBuffer.append(",\"");
                }
                stringBuffer.append(tail);
                stringBuffer.append('\"');
            }
            sb.append(stringBuffer).append(')').append(';');
            iconImage = true;
        }
        if (iconImage && layoutObject.containsKey("icon-offset") && (offset = layoutObject.getJsonArray("icon-offset").getValuesAs(JsonNumber.class)).size() == 2) {
            sb.append("icon-offset-x:").append(offset.get(0).doubleValue()).append(';').append("icon-offset-y:").append(offset.get(1).doubleValue()).append(';');
        }
        if (iconImage && paintObject.containsKey("icon-opacity")) {
            double opacity = paintObject.getJsonNumber("icon-opacity").doubleValue();
            sb.append("icon-opacity:").append(opacity).append(';');
        }
        if (iconImage && layoutObject.containsKey("icon-rotate")) {
            double rotation = layoutObject.getJsonNumber("icon-rotate").doubleValue();
            sb.append("icon-rotation:").append(rotation).append(';');
        }
        if (paintObject.containsKey("text-color")) {
            sb.append("text-color").append(':').append(paintObject.getString("text-color")).append(';');
        }
        if (layoutObject.containsKey("text-field")) {
            sb.append("text").append(':').append(layoutObject.getString("text-field").replace("}", EMPTY_STRING).replace("{", EMPTY_STRING)).append(';');
        }
        if (layoutObject.containsKey("text-font")) {
            List fonts = layoutObject.getJsonArray("text-font").stream().filter(JsonString.class::isInstance).map(JsonString.class::cast).map(JsonString::getString).collect(Collectors.toList());
            Font[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (String fontString : fonts) {
                Font setFont;
                Collection fontMatches = Stream.of(systemFonts).filter(font -> Arrays.asList(font.getName(), font.getFontName(), font.getFamily(), font.getPSName()).contains(fontString)).collect(Collectors.toList());
                if (fontMatches.isEmpty() || (setFont = fontMatches.stream().filter(font -> font.getName().equals(fontString)).findAny().orElseGet(() -> fontMatches.stream().filter(font -> font.getFontName().equals(fontString)).findAny().orElseGet(() -> fontMatches.stream().filter(font -> font.getPSName().equals(fontString)).findAny().orElseGet(() -> fontMatches.stream().filter(font -> font.getFamily().equals(fontString)).findAny().orElse(null))))) == null) continue;
                sb.append("font-family").append(':').append('\"').append(setFont.getFamily()).append('\"').append(';');
                sb.append("font-weight").append(':').append(setFont.isBold() ? "bold" : "normal").append(';');
                sb.append("font-style").append(':').append(setFont.isItalic() ? "italic" : "normal").append(';');
                break;
            }
        }
        if (paintObject.containsKey("text-halo-color")) {
            sb.append("text-halo-color").append(':').append(paintObject.getString("text-halo-color")).append(';');
        }
        if (paintObject.containsKey("text-halo-width")) {
            sb.append("text-halo-radius").append(':').append(paintObject.getJsonNumber("text-halo-width").intValue() / 2).append(';');
        }
        if (paintObject.containsKey("text-opacity")) {
            sb.append("text-opacity").append(':').append(paintObject.getJsonNumber("text-opacity").doubleValue()).append(';');
        }
        JsonNumber textSize = layoutObject.getJsonNumber("text-size");
        sb.append("font-size").append(':').append(textSize != null ? textSize.numberValue().toString() : "16").append(';');
        return sb.toString();
    }

    private static String parsePaintBackground(JsonObject paintObject) {
        StringBuilder sb = new StringBuilder(20);
        String bgColor = paintObject.getString("background-color", null);
        if (bgColor != null) {
            sb.append("fill-color").append(':').append(bgColor).append(';');
        }
        return sb.toString();
    }

    private static String parsePaintFill(JsonObject paintObject) {
        StringBuilder sb = new StringBuilder(50).append("fill-color").append(':').append(paintObject.getString("fill-color", "#000000")).append(';');
        JsonNumber opacity = paintObject.getJsonNumber("fill-opacity");
        sb.append("fill-opacity").append(':').append(opacity != null ? opacity.numberValue().toString() : "1").append(';').append("color").append(':').append(paintObject.getString("fill-outline-color", paintObject.getString("fill-color", "#000000"))).append(';');
        return sb.toString();
    }

    public String toString() {
        if (this.filter.toString().isEmpty() && this.paint.isEmpty()) {
            return EMPTY_STRING;
        }
        if (this.type == Type.BACKGROUND) {
            return "canvas{" + this.paint + "}";
        }
        String zoomSelector = this.minZoom == this.maxZoom ? "|z" + this.minZoom : (this.minZoom > Integer.MIN_VALUE && this.maxZoom == Integer.MAX_VALUE ? "|z" + this.minZoom + "-" : (this.minZoom == Integer.MIN_VALUE && this.maxZoom < Integer.MAX_VALUE ? "|z-" + this.maxZoom : (this.minZoom > Integer.MIN_VALUE ? MessageFormat.format("|z{0}-{1}", this.minZoom, this.maxZoom) : EMPTY_STRING)));
        String commonData = zoomSelector + this.filter.toString() + "::" + this.id + "{" + this.paint + "}";
        if (this.type == Type.CIRCLE || this.type == Type.SYMBOL) {
            return "node" + commonData;
        }
        if (this.type == Type.FILL) {
            return "area" + commonData;
        }
        if (this.type == Type.LINE) {
            return "way" + commonData;
        }
        return super.toString();
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceLayer() {
        return this.sourceLayer;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            Layers o = (Layers)other;
            return this.type == o.type && this.minZoom == o.minZoom && this.maxZoom == o.maxZoom && Objects.equals(this.id, o.id) && Objects.equals(this.styleId, o.styleId) && Objects.equals(this.sourceLayer, o.sourceLayer) && Objects.equals(this.source, o.source) && Objects.equals(this.filter, o.filter) && Objects.equals(this.paint, o.paint);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.minZoom, this.maxZoom, this.id, this.styleId, this.sourceLayer, this.source, this.filter, this.paint});
    }

    static enum Type {
        FILL,
        LINE,
        SYMBOL,
        CIRCLE,
        HEATMAP,
        FILL_EXTRUSION,
        RASTER,
        HILLSHADE,
        BACKGROUND,
        SKY;

    }
}

