/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetValidation;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.gui.tagging.presets.items.Optional;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetLink;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.tagging.presets.items.Space;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;
import org.xml.sax.SAXException;

public class TaggingPreset
extends AbstractAction
implements MainLayerManager.ActiveLayerChangeListener,
AdaptableAction,
Predicate<IPrimitive> {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    public static final String PRESET_ICON_ERROR_MSG_PREFIX = "Could not get presets icon ";
    public static final BooleanProperty USE_VALIDATOR = new BooleanProperty("taggingpreset.validator", false);
    public TaggingPresetMenu group;
    public String name;
    public String iconName;
    public String name_context;
    public String locale_name;
    public boolean preset_name_label;
    public transient Set<TaggingPresetType> types;
    public final transient List<TaggingPresetItem> data = new ArrayList<TaggingPresetItem>(2);
    public transient Roles roles;
    public transient TemplateEntry nameTemplate;
    public transient SearchCompiler.Match nameTemplateFilter;
    public transient SearchCompiler.Match matchExpression;
    private boolean originalSelectionEmpty;
    private CompletableFuture<Void> iconFuture;

    public TaggingPreset() {
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
        this.putValue(OPTIONAL_TOOLTIP_TEXT, this.group != null ? I18n.tr("Use preset ''{0}'' of group ''{1}''", this.getLocaleName(), this.group.getName()) : I18n.tr("Use preset ''{0}''", this.getLocaleName()));
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, TaggingPresetItem.fixPresetString(this.name)) : I18n.tr(TaggingPresetItem.fixPresetString(this.name), new Object[0]);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + '/' + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + '/' + this.name : this.name;
    }

    public final ImageIcon getIcon() {
        return this.getIcon("SmallIcon");
    }

    public final ImageIcon getIcon(String key) {
        Object icon = this.getValue(key);
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return null;
    }

    public final ImageResource getImageResource() {
        return ImageResource.getAttachedImageResource(this);
    }

    public void setIcon(String iconName) {
        this.iconName = iconName;
        if (iconName == null || !TaggingPresetReader.isLoadIcons()) {
            return;
        }
        File arch = TaggingPresetReader.getZipIcons();
        Object s = TaggingPresets.ICON_SOURCES.get();
        this.iconFuture = new CompletableFuture();
        new ImageProvider(iconName).setDirs((Collection<String>)s).setId("presets").setArchive(arch).setOptional(true).getResourceAsync(result -> {
            if (result != null) {
                GuiHelper.runInEDT(() -> {
                    try {
                        result.attachImageIcon(this, true);
                    }
                    catch (IllegalArgumentException e) {
                        Logging.warn(this.toString() + ": " + PRESET_ICON_ERROR_MSG_PREFIX + iconName);
                        Logging.warn(e);
                    }
                    finally {
                        this.iconFuture.complete(null);
                    }
                });
            } else {
                Logging.warn(this.toString() + ": " + PRESET_ICON_ERROR_MSG_PREFIX + iconName);
                this.iconFuture.complete(null);
            }
        });
    }

    public void setType(String types) throws SAXException {
        this.types = TaggingPresetItem.getType(types);
    }

    public void setName_template(String pattern) throws SAXException {
        try {
            this.nameTemplate = new TemplateParser(pattern).parse();
        }
        catch (ParseError e) {
            Logging.error("Error while parsing " + pattern + ": " + e.getMessage());
            throw new SAXException(e);
        }
    }

    public void setName_template_filter(String filter) throws SAXException {
        try {
            this.nameTemplateFilter = SearchCompiler.compile(filter);
        }
        catch (SearchParseError e) {
            Logging.error("Error while parsing" + filter + ": " + e.getMessage());
            throw new SAXException(e);
        }
    }

    public void setMatch_expression(String filter) throws SAXException {
        try {
            this.matchExpression = SearchCompiler.compile(filter);
        }
        catch (SearchParseError e) {
            Logging.error("Error while parsing" + filter + ": " + e.getMessage());
            throw new SAXException(e);
        }
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> selected) {
        List directlyAppliedTags;
        PresetPanel p = new PresetPanel();
        LinkedList<Link> l = new LinkedList<Link>();
        JPanel pp = new JPanel();
        if (this.types != null) {
            for (TaggingPresetType t : this.types) {
                JLabel la = new JLabel(ImageProvider.get(t.getIconName()));
                la.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(t.getName(), new Object[0])));
                pp.add(la);
            }
        }
        if (!(directlyAppliedTags = Utils.filteredCollection(this.data, Key.class).stream().map(Key::asTag).collect(Collectors.toList())).isEmpty()) {
            JLabel label = new JLabel(ImageProvider.get("pastetags"));
            label.setToolTipText("<html>" + I18n.tr("This preset also sets: {0}", Utils.joinAsHtmlUnorderedList(directlyAppliedTags)));
            pp.add(label);
        }
        JLabel validationLabel = new JLabel(ImageProvider.get("warning-small", ImageProvider.ImageSizes.LARGEICON));
        validationLabel.setVisible(false);
        pp.add(validationLabel);
        int count = pp.getComponentCount();
        if (this.preset_name_label) {
            p.add((Component)new JLabel(this.getIcon("SwingLargeIconKey")), GBC.std(0, 0).span(1, count > 0 ? 2 : 1).insets(0, 0, 5, 0));
        }
        if (count > 0) {
            p.add((Component)pp, GBC.std(1, 0).span(0));
        }
        if (this.preset_name_label) {
            p.add((Component)new JLabel(this.getName()), GBC.std(1, count > 0 ? 1 : 0).insets(5, 0, 0, 0).span(0).fill(2));
        }
        boolean presetInitiallyMatches = !selected.isEmpty() && selected.stream().allMatch(this);
        TaggingPresetItemGuiSupport itemGuiSupport = TaggingPresetItemGuiSupport.create(presetInitiallyMatches, selected, this::getChangedTags);
        JPanel items = new JPanel(new GridBagLayout());
        TaggingPresetItem previous = null;
        for (TaggingPresetItem i : this.data) {
            if (i instanceof Link) {
                l.add((Link)i);
                p.hasElements = true;
            } else {
                if (i instanceof PresetLink) {
                    PresetLink link = (PresetLink)i;
                    if (!(previous instanceof PresetLink) || !Objects.equals(((PresetLink)previous).text, link.text)) {
                        items.add((Component)link.createLabel(), GBC.eol().insets(0, 8, 0, 0));
                    }
                }
                if (i.addToPanel(items, itemGuiSupport)) {
                    p.hasElements = true;
                }
            }
            previous = i;
        }
        p.add((Component)items, GBC.eol().fill());
        if (selected.isEmpty() && !this.supportsRelation()) {
            GuiHelper.setEnabledRec(items, false);
        }
        if (selected.size() == 1 && USE_VALIDATOR.get().booleanValue()) {
            itemGuiSupport.addListener((source, key, newValue) -> TaggingPresetValidation.validateAsync((OsmPrimitive)selected.iterator().next(), validationLabel, this.getChangedTags()));
        }
        for (Link link : l) {
            link.addToPanel(p, itemGuiSupport);
        }
        JToggleButton tb = new JToggleButton(new ToolbarButtonAction());
        tb.setFocusable(false);
        p.add((Component)tb, GBC.std(1, 0).anchor(22));
        itemGuiSupport.fireItemValueModified(null, null, null);
        return p;
    }

    public boolean isShowable() {
        return this.data.stream().anyMatch(i -> !(i instanceof Optional) && !(i instanceof Space) && !(i instanceof Key));
    }

    public String suggestRoleForOsmPrimitive(OsmPrimitive osm) {
        if (this.roles != null && osm != null) {
            return this.roles.roles.stream().filter(i -> i.memberExpression != null && i.memberExpression.match(osm)).filter(i -> i.types == null || i.types.isEmpty() || i.types.contains((Object)TaggingPresetType.forPrimitive(osm))).findFirst().map(i -> i.key).orElse(null);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        if (ds == null) {
            return;
        }
        this.showAndApply(ds.getSelected());
    }

    public void showAndApply(Collection<OsmPrimitive> primitives) {
        Collection<OsmPrimitive> sel = this.createSelection(primitives);
        int answer = this.showDialog(sel, this.supportsRelation());
        if (!sel.isEmpty() && answer == 1) {
            Command cmd = TaggingPreset.createCommand(sel, this.getChangedTags());
            if (cmd != null) {
                UndoRedoHandler.getInstance().add(cmd);
            }
        } else if (answer == 2) {
            SubclassFilteredCollection<OsmPrimitive, Way> ways;
            Pair<Relation, Relation> res;
            Relation calculated = null;
            if (this.getChangedTags().stream().anyMatch(t -> "boundary".equals(t.get("type")) || "multipolygon".equals(t.get("type"))) && (res = CreateMultipolygonAction.createMultipolygonRelation(ways = Utils.filteredCollection(primitives, Way.class), true)) != null) {
                calculated = (Relation)res.b;
            }
            Relation r = calculated != null ? calculated : new Relation();
            LinkedHashSet<RelationMember> members = new LinkedHashSet<RelationMember>(r.getMembers());
            for (Tag t2 : this.getChangedTags()) {
                r.put(t2.getKey(), t2.getValue());
            }
            for (OsmPrimitive osm : primitives) {
                if (r == calculated && osm instanceof Way) continue;
                String role = this.suggestRoleForOsmPrimitive(osm);
                RelationMember rm = new RelationMember(role == null ? "" : role, osm);
                r.addMember(rm);
                members.add(rm);
            }
            if (r.isMultipolygon() && r != calculated) {
                r.setMembers(RelationSorter.sortMembersByConnectivity(r.getMembers()));
            }
            SwingUtilities.invokeLater(() -> RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), r, members).setVisible(true));
        }
        if (!primitives.isEmpty()) {
            DataSet ds = primitives.iterator().next().getDataSet();
            ds.setSelected(primitives);
        }
    }

    public int showDialog(Collection<OsmPrimitive> sel, boolean showNewRelation) {
        boolean canCreateRelation;
        PresetPanel p = this.createPanel(sel);
        int answer = 1;
        boolean bl = canCreateRelation = this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
        if (this.originalSelectionEmpty && !canCreateRelation) {
            new Notification(I18n.tr("The preset <i>{0}</i> cannot be applied since nothing has been selected!", this.getLocaleName())).setIcon(2).show();
            return 3;
        }
        if (sel.isEmpty() && !canCreateRelation) {
            new Notification(I18n.tr("The preset <i>{0}</i> cannot be applied since the selection is unsuitable!", this.getLocaleName())).setIcon(2).show();
            return 3;
        }
        if (p.getComponentCount() != 0 && (sel.isEmpty() || p.hasElements)) {
            boolean disableApply;
            int size = sel.size();
            String title = I18n.trn("Change {0} object", "Change {0} objects", size, size);
            if (!showNewRelation && size == 0) {
                title = this.originalSelectionEmpty ? I18n.tr("Nothing selected!", new Object[0]) : I18n.tr("Selection unsuitable!", new Object[0]);
            }
            boolean bl2 = disableApply = size == 0;
            if (!disableApply) {
                DataSet ds = sel.iterator().next().getDataSet();
                disableApply = ds != null && ds.isLocked();
            }
            answer = new PresetDialog((Component)p, title, this.preset_name_label ? null : (ImageIcon)this.getValue("SmallIcon"), disableApply, showNewRelation).getValue();
        }
        if (!showNewRelation && answer == 2) {
            return 3;
        }
        return answer;
    }

    public Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> participants) {
        this.originalSelectionEmpty = participants.isEmpty();
        return participants.stream().filter(this::typeMatches).collect(Collectors.toList());
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        this.data.forEach(i -> i.addCommands(result));
        return result;
    }

    public static Command createCommand(Collection<OsmPrimitive> sel, List<Tag> changedTags) {
        List<Command> cmds = changedTags.stream().map(tag -> new ChangePropertyCommand(sel, tag.getKey(), tag.getValue())).filter(cmd -> cmd.getObjectsNumber() > 0).collect(StreamUtils.toUnmodifiableList());
        return cmds.isEmpty() ? null : SequenceCommand.wrapIfNeeded(I18n.tr("Change Tags", new Object[0]), cmds);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
    }

    protected final void updateEnabledState() {
        this.setEnabled(OsmDataManager.getInstance().getEditDataSet() != null);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types.toString()) + ' ' + this.name;
    }

    public final boolean typeMatches(IPrimitive primitive) {
        return this.typeMatches(EnumSet.of(TaggingPresetType.forPrimitive(primitive)));
    }

    public boolean typeMatches(Collection<TaggingPresetType> t) {
        return t == null || this.types == null || this.types.containsAll(t);
    }

    @Override
    public boolean test(IPrimitive p) {
        return this.matches(EnumSet.of(TaggingPresetType.forPrimitive(p)), p.getKeys(), false);
    }

    public boolean matches(Collection<TaggingPresetType> t, Map<String, String> tags, boolean onlyShowable) {
        if (onlyShowable && !this.isShowable() || !this.typeMatches(t)) {
            return false;
        }
        if (this.matchExpression != null && !this.matchExpression.match(Tagged.ofMap(tags))) {
            return false;
        }
        return TaggingPresetItem.matches(this.data, tags);
    }

    public String getToolbarString() {
        ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
        return actionParser.saveAction(new ToolbarPreferences.ActionDefinition(this));
    }

    public CompletableFuture<Void> getIconLoadingTask() {
        return this.iconFuture;
    }

    private static class PresetPanel
    extends JPanel {
        private boolean hasElements;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }

    public class ToolbarButtonAction
    extends AbstractAction {
        private final int toolbarIndex;

        public ToolbarButtonAction() {
            super("");
            new ImageProvider("dialogs", "pin").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Add or remove toolbar button", new Object[0]));
            ArrayList<String> t = new ArrayList<String>(ToolbarPreferences.getToolString());
            this.toolbarIndex = t.indexOf(TaggingPreset.this.getToolbarString());
            this.putValue("SwingSelectedKey", this.toolbarIndex >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String res = TaggingPreset.this.getToolbarString();
            MainApplication.getToolbar().addCustomButton(res, this.toolbarIndex, true);
        }
    }

    private static class PresetDialog
    extends ExtendedDialog {
        PresetDialog(Component content, String title, ImageIcon icon, boolean disableApply, boolean showNewRelation) {
            String[] stringArray;
            MainFrame mainFrame = MainApplication.getMainFrame();
            if (showNewRelation) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = I18n.tr("Apply Preset", new Object[0]);
                stringArray2[1] = I18n.tr("New relation", new Object[0]);
                stringArray = stringArray2;
                stringArray2[2] = I18n.tr("Cancel", new Object[0]);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = I18n.tr("Apply Preset", new Object[0]);
                stringArray = stringArray3;
                stringArray3[1] = I18n.tr("Cancel", new Object[0]);
            }
            super((Component)mainFrame, title, stringArray, true);
            if (icon != null) {
                this.setIconImage(icon.getImage());
            }
            this.contentInsets = new Insets(10, 5, 0, 5);
            if (showNewRelation) {
                this.setButtonIcons("ok", "data/relation", "cancel");
            } else {
                this.setButtonIcons("ok", "cancel");
            }
            this.configureContextsensitiveHelp("/Menu/Presets", true);
            this.setContent(content);
            this.setDefaultButton(1);
            this.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!disableApply);
            ((JButton)this.buttons.get(0)).setToolTipText(title);
            Dimension d = this.getSize();
            if (d.width < 350) {
                d.width = 350;
                this.setSize(d);
            }
            super.showDialog();
        }
    }
}

