/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangesetContentParser;
import org.openstreetmap.josm.io.OsmChangesetParser;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlParsingException;

public class OsmServerChangesetReader
extends OsmServerReader {
    final boolean useAnonymousUser;

    public OsmServerChangesetReader() {
        this(false);
    }

    public OsmServerChangesetReader(boolean useAnonymousUser) {
        this.useAnonymousUser = useAnonymousUser;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    protected final InputStream getChangesetInputStream(long id, boolean includeDiscussion, ProgressMonitor monitor) throws OsmTransferException {
        StringBuilder sb = new StringBuilder(48).append("changeset/").append(id);
        if (includeDiscussion) {
            sb.append("?include_discussion=true");
        }
        return this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Changeset> queryChangesets(ChangesetQuery query, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(query, "query");
        List<Changeset> result = null;
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Reading changesets...", new Object[0]));
            StringBuilder sb = new StringBuilder();
            sb.append("changesets?").append(query.getQueryString());
            try {
                InputStream in;
                block18: {
                    in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
                    if (in != null) break block18;
                    List<Changeset> list = Collections.emptyList();
                    if (in == null) return list;
                    in.close();
                    return list;
                }
                try {
                    monitor.indeterminateSubTask(I18n.tr("Downloading changesets ...", new Object[0]));
                    result = OsmChangesetParser.parse(in, monitor.createSubTaskMonitor(1, true));
                    return result;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                Logging.warn(e);
                return result;
            }
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Changeset readChangeset(long id, boolean includeDiscussion, ProgressMonitor monitor) throws OsmTransferException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", id));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        Changeset result = null;
        try {
            InputStream in;
            monitor.beginTask(I18n.tr("Reading changeset {0} ...", id));
            try {
                List<Changeset> changesets;
                block22: {
                    block21: {
                        in = this.getChangesetInputStream(id, includeDiscussion, monitor);
                        if (in != null) break block21;
                        Changeset changeset = null;
                        if (in == null) return changeset;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        in.close();
                        return changeset;
                    }
                    monitor.indeterminateSubTask(I18n.tr("Downloading changeset {0} ...", id));
                    changesets = OsmChangesetParser.parse(in, monitor.createSubTaskMonitor(1, true));
                    if (changesets != null && !changesets.isEmpty()) break block22;
                    Changeset changeset = null;
                    if (in == null) return changeset;
                    in.close();
                    return changeset;
                }
                result = changesets.get(0);
                return result;
            }
            catch (IOException e) {
                Logging.warn(e);
                return result;
            }
            {
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Changeset> readChangesets(Collection<Integer> ids, boolean includeDiscussion, ProgressMonitor monitor) throws OsmTransferException {
        if (ids == null) {
            return Collections.emptyList();
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.trn("Downloading {0} changeset ...", "Downloading {0} changesets ...", ids.size(), ids.size()));
            monitor.setTicksCount(ids.size());
            ArrayList<Changeset> ret = new ArrayList<Changeset>();
            int i = 0;
            Object object = ids.iterator();
            while (object.hasNext()) {
                int id = object.next();
                if (id <= 0) continue;
                ++i;
                try {
                    InputStream in;
                    block20: {
                        in = this.getChangesetInputStream(id, includeDiscussion, monitor);
                        if (in != null) break block20;
                        List<Changeset> list = null;
                        if (in == null) return list;
                        in.close();
                        return list;
                    }
                    try {
                        monitor.indeterminateSubTask(I18n.tr("({0}/{1}) Downloading changeset {2}...", i, ids.size(), id));
                        List<Changeset> changesets = OsmChangesetParser.parse(in, monitor.createSubTaskMonitor(1, true));
                        if (changesets == null || changesets.isEmpty()) continue;
                        ret.addAll(changesets);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    Logging.warn(e);
                }
                monitor.worked(1);
            }
            object = Collections.unmodifiableList(ret);
            return object;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangesetDataSet downloadChangeset(int id, ProgressMonitor monitor) throws OsmTransferException {
        if (id <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type integer > 0 for parameter ''{0}'', got {1}", "id", id));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        ChangesetDataSet result = null;
        try {
            monitor.beginTask(I18n.tr("Downloading changeset content", new Object[0]));
            StringBuilder sb = new StringBuilder(32).append("changeset/").append(id).append("/download");
            try {
                InputStream in;
                block18: {
                    in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
                    if (in != null) break block18;
                    ChangesetDataSet changesetDataSet = null;
                    if (in == null) return changesetDataSet;
                    in.close();
                    return changesetDataSet;
                }
                try {
                    monitor.setCustomText(I18n.tr("Downloading content for changeset {0} ...", id));
                    OsmChangesetContentParser parser = new OsmChangesetContentParser(in);
                    result = parser.parse(monitor.createSubTaskMonitor(1, true), this.useAnonymousUser);
                    return result;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                Logging.warn(e);
                return result;
            }
        }
        catch (XmlParsingException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }
}

