/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.tools.template_engine.ParseError;

public class Tokenizer {
    private final Set<Character> specialCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('$'), Character.valueOf('?'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('\''), Character.valueOf('!')));
    private final String template;
    private int c;
    private int index;
    private Token currentToken;
    private final StringBuilder text = new StringBuilder();

    public Tokenizer(String template) {
        this.template = template;
        this.getChar();
    }

    private void getChar() {
        this.c = this.index >= this.template.length() ? -1 : (int)this.template.charAt(this.index++);
    }

    public Token nextToken() throws ParseError {
        if (this.currentToken != null) {
            Token result = this.currentToken;
            this.currentToken = null;
            return result;
        }
        int position = this.index;
        this.text.setLength(0);
        switch (this.c) {
            case -1: {
                return new Token(TokenType.EOF, position);
            }
            case 123: {
                this.getChar();
                return new Token(TokenType.VARIABLE_START, position);
            }
            case 63: {
                this.getChar();
                if (this.c == 123) {
                    this.getChar();
                    return new Token(TokenType.CONDITION_START, position);
                }
                throw ParseError.unexpectedChar('{', (char)this.c, position);
            }
            case 33: {
                this.getChar();
                if (this.c == 123) {
                    this.getChar();
                    return new Token(TokenType.CONTEXT_SWITCH_START, position);
                }
                throw ParseError.unexpectedChar('{', (char)this.c, position);
            }
            case 125: {
                this.getChar();
                return new Token(TokenType.END, position);
            }
            case 124: {
                this.getChar();
                return new Token(TokenType.PIPE, position);
            }
            case 39: {
                this.getChar();
                return new Token(TokenType.APOSTROPHE, position);
            }
        }
        while (this.c != -1 && !this.specialCharacters.contains(Character.valueOf((char)this.c))) {
            if (this.c == 92) {
                this.getChar();
                if (this.c == 110) {
                    this.c = 10;
                }
            }
            this.text.append((char)this.c);
            this.getChar();
        }
        return new Token(TokenType.TEXT, position, this.text.toString());
    }

    public Token lookAhead() throws ParseError {
        if (this.currentToken == null) {
            this.currentToken = this.nextToken();
        }
        return this.currentToken;
    }

    public Token skip(char lastChar) {
        this.currentToken = null;
        int position = this.index;
        StringBuilder result = new StringBuilder();
        while (this.c != lastChar && this.c != -1) {
            if (this.c == 92) {
                this.getChar();
            }
            result.append((char)this.c);
            this.getChar();
        }
        return new Token(TokenType.TEXT, position, result.toString());
    }

    public static class Token {
        private final TokenType type;
        private final int position;
        private final String text;

        public Token(TokenType type, int position) {
            this(type, position, null);
        }

        public Token(TokenType type, int position, String text) {
            this.type = type;
            this.position = position;
            this.text = text;
        }

        public TokenType getType() {
            return this.type;
        }

        public int getPosition() {
            return this.position;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return (Object)((Object)this.type) + (this.text != null ? ' ' + this.text : "");
        }
    }

    public static enum TokenType {
        CONDITION_START,
        VARIABLE_START,
        CONTEXT_SWITCH_START,
        END,
        PIPE,
        APOSTROPHE,
        TEXT,
        EOF;

    }
}

