/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.io.importexport.NMEAImporter;
import org.openstreetmap.josm.gui.io.importexport.RtkLibImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GpxTracksSessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        Layer layer;
        block14: {
            String version = elem.getAttribute("version");
            if (!"0.1".equals(version)) {
                throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for gpx track layer is not supported. Expected: 0.1", version));
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression fileExp = xpath.compile("file/text()");
            String fileStr = (String)fileExp.evaluate(elem, XPathConstants.STRING);
            if (Utils.isEmpty(fileStr)) {
                throw new IllegalDataException(I18n.tr("File name expected for layer no. {0}", support.getLayerIndex()));
            }
            InputStream in = support.getInputStream(fileStr);
            try {
                NodeList markerNodes;
                GpxImporter.GpxImporterData importData = NMEAImporter.FILE_FILTER.acceptName(fileStr) ? NMEAImporter.loadLayers(in, support.getFile(fileStr), support.getLayerName()) : (RtkLibImporter.FILE_FILTER.acceptName(fileStr) ? RtkLibImporter.loadLayers(in, support.getFile(fileStr), support.getLayerName()) : GpxImporter.loadLayers(in, support.getFile(fileStr), support.getLayerName(), progressMonitor));
                if (importData.getGpxLayer() != null && importData.getGpxLayer().data != null) {
                    importData.getGpxLayer().data.fromSession = true;
                }
                if ((markerNodes = elem.getElementsByTagName("markerLayer")).getLength() > 0 && markerNodes.item(0).getNodeType() == 1) {
                    Element markerEl = (Element)markerNodes.item(0);
                    try {
                        int index = Integer.parseInt(markerEl.getAttribute("index"));
                        support.addSubLayer(index, importData.getMarkerLayer(), markerEl);
                    }
                    catch (NumberFormatException ex) {
                        Logging.warn(ex);
                    }
                }
                support.addPostLayersTask(importData.getPostLayerTask());
                layer = this.getLayer(importData);
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XPathExpressionException e) {
                    throw new IllegalDataException(e);
                }
            }
            in.close();
        }
        return layer;
    }

    protected Layer getLayer(GpxImporter.GpxImporterData importData) {
        return importData.getGpxLayer();
    }
}

