/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import javax.swing.Action;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;

public interface IRelationEditorActionAccess {
    default public void addMemberTableAction(String actionMapKey, Action action) {
        this.getMemberTable().getActionMap().put(actionMapKey, action);
    }

    public MemberTable getMemberTable();

    public MemberTableModel getMemberTableModel();

    public SelectionTable getSelectionTable();

    public SelectionTableModel getSelectionTableModel();

    public IRelationEditor getEditor();

    public TagEditorModel getTagModel();

    default public IRelation<?> getChangedRelation() {
        Relation oldRelation = this.getEditor().getRelation();
        boolean isUploadInProgress = MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().anyMatch(OsmDataLayer::isUploadInProgress);
        if (isUploadInProgress || oldRelation != null && oldRelation.getDataSet() != null && oldRelation.getDataSet().isLocked()) {
            return oldRelation;
        }
        Relation newRelation = oldRelation != null ? new Relation(oldRelation) : new Relation();
        this.getTagModel().applyToPrimitive(newRelation);
        this.getMemberTableModel().applyToRelation(newRelation);
        return newRelation;
    }

    public AutoCompletingTextField getTextFieldRole();

    default public boolean stopMemberCellEditing() {
        return this.getMemberTable().isEditing() && this.getMemberTable().getCellEditor().stopCellEditing();
    }
}

