/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class FeaturesHandler
extends RequestHandler {
    public static final String command = "features";

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        String q = (String)this.args.get("q");
        List<String> handlers = q == null ? null : Arrays.asList(q.split("[,\\s]+", -1));
        this.content = FeaturesHandler.getHandlersInfoAsJSON(handlers).toString();
        this.contentType = "application/json";
        if (this.args.containsKey("jsonp")) {
            this.content = (String)this.args.get("jsonp") + " && " + (String)this.args.get("jsonp") + '(' + this.content + ')';
        }
    }

    private static JsonArray getHandlersInfoAsJSON(Collection<String> handlers) {
        JsonArrayBuilder json = Json.createArrayBuilder();
        RequestProcessor.getHandlersInfo(handlers).map(FeaturesHandler::getHandlerInfoAsJSON).forEach(json::add);
        return json.build();
    }

    private static JsonObject getHandlerInfoAsJSON(RequestHandler handler) {
        JsonObjectBuilder json = Json.createObjectBuilder();
        json.add("request", handler.getCommand());
        if (handler.getUsage() != null) {
            json.add("usage", handler.getUsage());
        }
        json.add("parameters", FeaturesHandler.toJsonArray(handler.getMandatoryParams()));
        json.add("optional", FeaturesHandler.toJsonArray(handler.getOptionalParams()));
        json.add("examples", FeaturesHandler.toJsonArray(handler.getUsageExamples(handler.getCommand())));
        return json.build();
    }

    private static JsonArray toJsonArray(String[] strings) {
        return Arrays.stream(strings).collect(Collectors.collectingAndThen(Collectors.toList(), Json::createArrayBuilder)).build();
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to report its supported features. This enables web sites to guess a running JOSM version", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.READ_PROTOCOL_VERSION;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[0];
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"jsonp", "q"};
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
    }

    @Override
    public String getUsage() {
        return "reports available commands, their parameters and examples";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/features", "/features?q=import,add_node"};
    }
}

