/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class RelationChecker
extends Test
implements TaggingPresetListener {
    public static final int ROLE_UNKNOWN = 1701;
    public static final int ROLE_EMPTY = 1702;
    public static final int HIGH_COUNT = 1704;
    public static final int LOW_COUNT = 1705;
    public static final int ROLE_MISSING = 1706;
    public static final int RELATION_UNKNOWN = 1707;
    public static final int WRONG_ROLE = 1708;
    public static final int WRONG_TYPE = 1709;
    public static final int RELATION_LOOP = 1710;
    public static final int RELATION_EMPTY = 1711;
    private static final BooleanProperty ALLOW_COMPLEX_LOOP = new BooleanProperty("validator.relation.allow.complex.dependency", false);
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private boolean ignoreMultiPolygons;
    private boolean ignoreTurnRestrictions;
    private final List<List<Relation>> loops = new ArrayList<List<Relation>>();
    private static final Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        TaggingPresets.addListener(this);
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        for (TaggingPreset p : TaggingPresets.getTaggingPresets()) {
            if (!p.data.stream().anyMatch(i -> i instanceof Roles)) continue;
            relationpresets.add(p);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        for (Test t : OsmValidator.getEnabledTests(false)) {
            if (t instanceof MultipolygonTest) {
                this.ignoreMultiPolygons = true;
            }
            if (!(t instanceof TurnrestrictionTest)) continue;
            this.ignoreTurnRestrictions = true;
        }
    }

    @Override
    public void visit(Relation n) {
        Map<String, RoleInfo> map = RelationChecker.buildRoleInfoMap(n);
        if (map.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1711).message(I18n.tr("Relation is empty", new Object[0])).primitives(n).build());
        }
        if (this.ignoreMultiPolygons && n.isMultipolygon()) {
            return;
        }
        if (this.ignoreTurnRestrictions && n.hasTag("type", "restriction")) {
            return;
        }
        Map<Roles.Role, String> allroles = RelationChecker.buildAllRoles(n);
        if (allroles.isEmpty() && n.hasTag("type", "route") && n.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1")).primitives(n).build());
        } else if (n.hasKey("type") && allroles.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1707).message(I18n.tr("Relation type is unknown", new Object[0])).primitives(n).build());
        }
        if (!map.isEmpty() && !allroles.isEmpty()) {
            this.checkRoles(n, allroles, map);
        }
        this.checkLoop(n);
    }

    private static Map<String, RoleInfo> buildRoleInfoMap(Relation n) {
        HashMap<String, RoleInfo> map = new HashMap<String, RoleInfo>();
        for (RelationMember m : n.getMembers()) {
            map.computeIfAbsent(m.getRole(), k -> new RoleInfo()).total++;
        }
        return map;
    }

    private static Map<Roles.Role, String> buildAllRoles(Relation n) {
        LinkedHashMap<Roles.Role, String> allroles = new LinkedHashMap<Roles.Role, String>();
        for (TaggingPreset p : relationpresets) {
            boolean matches = TaggingPresetItem.matches(Utils.filteredCollection(p.data, KeyedItem.class), n.getKeys());
            SubclassFilteredCollection<TaggingPresetItem, Roles> roles = Utils.filteredCollection(p.data, Roles.class);
            if (!matches || roles.isEmpty()) continue;
            for (Roles.Role role : roles.iterator().next().roles) {
                allroles.put(role, p.name);
            }
        }
        return allroles;
    }

    private static boolean checkMemberType(Roles.Role r, RelationMember member) {
        if (r.types != null) {
            switch (member.getDisplayType()) {
                case NODE: {
                    return r.types.contains((Object)TaggingPresetType.NODE);
                }
                case CLOSEDWAY: {
                    return r.types.contains((Object)TaggingPresetType.CLOSEDWAY);
                }
                case WAY: {
                    return r.types.contains((Object)TaggingPresetType.WAY);
                }
                case MULTIPOLYGON: {
                    return r.types.contains((Object)TaggingPresetType.MULTIPOLYGON);
                }
                case RELATION: {
                    return r.types.contains((Object)TaggingPresetType.RELATION);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkMemberExpressionAndType(Map<Roles.Role, String> allroles, RelationMember member, Relation n) {
        String role = member.getRole();
        String name = null;
        EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
        TestError possibleMatchError = null;
        for (Map.Entry<Roles.Role, String> e : allroles.entrySet()) {
            Roles.Role r = e.getKey();
            if (!r.isRole(role)) continue;
            name = e.getValue();
            types.addAll(r.types);
            if (RelationChecker.checkMemberType(r, member)) {
                if (r.memberExpression == null) {
                    return true;
                }
                OsmPrimitive primitive = member.getMember();
                if (!primitive.isUsable()) {
                    return true;
                }
                if (r.memberExpression.match(primitive)) {
                    return true;
                }
                possibleMatchError = TestError.builder(this, Severity.WARNING, 1708).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role of relation member does not match template expression ''{0}'' in preset {1}"), r.memberExpression, name).primitives(member.getMember().isUsable() ? member.getMember() : n).build();
                continue;
            }
            if (OsmPrimitiveType.RELATION != member.getType() || member.getMember().isUsable() || !r.types.contains((Object)TaggingPresetType.MULTIPOLYGON)) continue;
            return true;
        }
        if (name == null) {
            return true;
        }
        if (possibleMatchError != null) {
            this.errors.add(possibleMatchError);
        } else {
            boolean ignored;
            boolean bl = ignored = member.getMember().isIncomplete() && OsmPrimitiveType.WAY == member.getType() && !types.contains((Object)TaggingPresetType.WAY) && types.contains((Object)TaggingPresetType.CLOSEDWAY);
            if (!ignored) {
                String typesStr = types.stream().map(x -> I18n.tr(x.getName(), new Object[0])).collect(Collectors.joining("/"));
                this.errors.add(TestError.builder(this, Severity.WARNING, 1709).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Type ''{0}'' of relation member with role ''{1}'' does not match accepted types ''{2}'' in preset {3}"), new Object[]{member.getType(), member.getRole(), typesStr, name}).primitives(member.getMember().isUsable() ? member.getMember() : n).build());
            }
        }
        return false;
    }

    private void checkRoles(Relation n, Map<Roles.Role, String> allroles, Map<String, RoleInfo> map) {
        for (RelationMember member : n.getMembers()) {
            this.checkMemberExpressionAndType(allroles, member, n);
        }
        for (Roles.Role r2 : allroles.keySet()) {
            String keyname = r2.key;
            if (keyname.isEmpty()) {
                keyname = I18n.tr("<empty>", new Object[0]);
            }
            this.checkRoleCounts(n, r2, keyname, map.get(r2.key));
        }
        if ("network".equals(n.get("type")) && !"bicycle".equals(n.get("route"))) {
            return;
        }
        for (String key : map.keySet()) {
            if (!allroles.keySet().stream().noneMatch(role -> role.isRole(key))) continue;
            String templates = allroles.keySet().stream().map(r -> r.key).map(r -> Utils.isEmpty(r) ? I18n.tr("<empty>", new Object[0]) : r).distinct().collect(Collectors.joining("/"));
            ArrayList<? extends OsmPrimitive> primitives = new ArrayList<OsmPrimitive>(n.findRelationMembers(key));
            primitives.add(0, n);
            if (!key.isEmpty()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1701).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role ''{0}'' is not among expected values ''{1}''"), key, templates).primitives(primitives).build());
                continue;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1702).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Empty role found when expecting one of ''{0}''"), templates).primitives(primitives).build());
        }
    }

    private void checkRoleCounts(Relation n, Roles.Role r, String keyname, RoleInfo ri) {
        long vc;
        long count = ri == null ? 0L : (long)ri.total;
        if (count != (vc = r.getValidCount(count))) {
            if (count == 0L) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1706).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role ''{0}'' missing"), keyname).primitives(n).build());
            } else if (vc > count) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1705).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of ''{0}'' roles too low ({1})"), keyname, count).primitives(n).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1704).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of ''{0}'' roles too high ({1})"), keyname, count).primitives(n).build());
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        if (this.isFixable(testError) && !primitives.iterator().next().isDeleted()) {
            if (testError.getCode() == 1711) {
                return new DeleteCommand(primitives);
            }
            if (testError.getCode() == 1710) {
                Relation old = (Relation)primitives.iterator().next();
                ArrayList<RelationMember> remaining = new ArrayList<RelationMember>(old.getMembers());
                remaining.removeIf(rm -> primitives.contains(rm.getMember()));
                return new ChangeMembersCommand(old, Utils.toUnmodifiableList(remaining));
            }
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        return testError.getCode() == 1711 && !primitives.isEmpty() && primitives.iterator().next().isNew() || testError.getCode() == 1710 && primitives.size() == 1;
    }

    @Override
    public void taggingPresetsModified() {
        relationpresets.clear();
        RelationChecker.initializePresets();
    }

    @Override
    public void endTest() {
        if (Boolean.TRUE.equals(ALLOW_COMPLEX_LOOP.get())) {
            this.loops.removeIf(loop -> loop.size() > 2);
        }
        this.loops.forEach(loop -> this.errors.add(TestError.builder(this, Severity.ERROR, 1710).message(loop.size() == 2 ? I18n.tr("Relation contains itself as a member", new Object[0]) : I18n.tr("Relations generate circular dependency of parent/child elements", new Object[0])).primitives(new LinkedHashSet(loop)).build()));
        this.loops.clear();
        super.endTest();
    }

    private void checkLoop(Relation r) {
        this.checkLoop(r, new LinkedList<Relation>());
    }

    private void checkLoop(Relation parent, List<Relation> path) {
        if (path.contains(parent)) {
            Iterator<List<Relation>> iter = this.loops.iterator();
            while (iter.hasNext()) {
                List<Relation> loop = iter.next();
                if (loop.size() > path.size() && loop.containsAll(path)) {
                    iter.remove();
                    continue;
                }
                if (path.size() < loop.size() || !path.containsAll(loop)) continue;
                return;
            }
            if (path.get(0).equals(parent)) {
                path.add(parent);
                this.loops.add(path);
            }
            return;
        }
        path.add(parent);
        for (Relation sub : parent.getMemberPrimitives(Relation.class)) {
            if (!sub.isUsable() || sub.isIncomplete()) continue;
            this.checkLoop(sub, new LinkedList<Relation>(path));
        }
    }

    public static List<Relation> checkAddMember(Relation parent, Relation child) {
        if (parent == null || child == null) {
            return Collections.emptyList();
        }
        RelationChecker test = new RelationChecker();
        LinkedList<Relation> path = new LinkedList<Relation>();
        path.add(parent);
        test.checkLoop(child, path);
        if (Boolean.TRUE.equals(ALLOW_COMPLEX_LOOP.get())) {
            test.loops.removeIf(loop -> loop.size() > 2);
        }
        if (test.loops.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(test.loops.iterator().next());
    }

    private static class RoleInfo {
        private int total;

        private RoleInfo() {
        }
    }
}

