/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Objects;
import org.openstreetmap.josm.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.io.UploadStrategy;

public class UploadStrategySpecification {
    public static final int UNSPECIFIED_CHUNK_SIZE = -1;
    private UploadStrategy strategy;
    private int chunkSize;
    private MaxChangesetSizeExceededPolicy policy;
    private boolean closeChangesetAfterUpload;

    public UploadStrategySpecification() {
        this.strategy = UploadStrategy.DEFAULT_UPLOAD_STRATEGY;
        this.chunkSize = -1;
        this.policy = null;
        this.closeChangesetAfterUpload = true;
    }

    public UploadStrategySpecification(UploadStrategySpecification other) {
        if (other != null) {
            this.strategy = other.strategy;
            this.chunkSize = other.chunkSize;
            this.policy = other.policy;
            this.closeChangesetAfterUpload = other.closeChangesetAfterUpload;
        }
    }

    public UploadStrategy getStrategy() {
        return this.strategy;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public static int getUnspecifiedChunkSize() {
        return -1;
    }

    public MaxChangesetSizeExceededPolicy getPolicy() {
        return this.policy;
    }

    public UploadStrategySpecification setStrategy(UploadStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public UploadStrategySpecification setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public UploadStrategySpecification setPolicy(MaxChangesetSizeExceededPolicy policy) {
        this.policy = policy;
        return this;
    }

    public UploadStrategySpecification setCloseChangesetAfterUpload(boolean closeChangesetAfterUpload) {
        this.closeChangesetAfterUpload = closeChangesetAfterUpload;
        return this;
    }

    public boolean isCloseChangesetAfterUpload() {
        return this.closeChangesetAfterUpload;
    }

    public int getNumRequests(int numObjects) {
        if (numObjects <= 0) {
            return 0;
        }
        switch (this.strategy) {
            case INDIVIDUAL_OBJECTS_STRATEGY: {
                return numObjects;
            }
            case SINGLE_REQUEST_STRATEGY: {
                return 1;
            }
            case CHUNKED_DATASET_STRATEGY: {
                if (this.chunkSize == -1) {
                    return 0;
                }
                return (int)Math.ceil((double)numObjects / (double)this.chunkSize);
            }
        }
        return 0;
    }

    public String toString() {
        return String.format("Strategy: %s, ChunkSize: %d, Policy: %s, Close after: %b", this.strategy.toString(), this.chunkSize, this.policy == null ? "none" : this.policy.toString(), this.closeChangesetAfterUpload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.strategy, this.chunkSize, this.policy, this.closeChangesetAfterUpload});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UploadStrategySpecification that = (UploadStrategySpecification)obj;
        return this.chunkSize == that.chunkSize && this.closeChangesetAfterUpload == that.closeChangesetAfterUpload && this.strategy == that.strategy && this.policy == that.policy;
    }
}

