/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.language.LanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastText {
    private static final Logger logger = LoggerFactory.getLogger(FastText.class);
    private static final int K_HIGHEST_SCORES = 5;
    private final Process fasttextProcess;
    private final BufferedReader fasttextIn;
    private final BufferedWriter fasttextOut;

    public FastText(File modelPath, File binaryPath) throws IOException {
        this.fasttextProcess = new ProcessBuilder(binaryPath.getPath(), "predict-prob", modelPath.getPath(), "-", "5").start();
        this.fasttextIn = new BufferedReader(new InputStreamReader(this.fasttextProcess.getInputStream(), StandardCharsets.UTF_8));
        this.fasttextOut = new BufferedWriter(new OutputStreamWriter(this.fasttextProcess.getOutputStream(), StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Double> runFasttext(String text, List<String> additionalLanguageCodes) throws IOException {
        String buffer;
        HashMap<String, Double> probabilities = new HashMap<String, Double>();
        String joined = text.replace("\n", " ");
        FastText fastText = this;
        synchronized (fastText) {
            this.fasttextOut.write(joined);
            this.fasttextOut.newLine();
            this.fasttextOut.flush();
            buffer = this.fasttextIn.readLine();
            if (buffer == null) {
                try {
                    logger.warn("fasttextIn.readLine() returned null, trying again after short delay");
                    Thread.sleep(10L);
                    buffer = this.fasttextIn.readLine();
                    if (buffer == null) {
                        logger.warn("fasttextIn.readLine() returned null again");
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        String[] values = buffer.split(" ");
        if (values.length % 2 != 0) {
            logger.error("Error while parsing fasttext output '{}'", (Object)buffer);
            throw new RuntimeException("Error while parsing fasttext output: " + buffer);
        }
        for (int i = 0; i < values.length; i += 2) {
            String lang = values[i];
            String langCode = lang.substring(lang.lastIndexOf("__") + 2);
            String prob = values[i + 1];
            Double probValue = Double.parseDouble(prob);
            if (!LanguageIdentifier.canLanguageBeDetected(langCode, additionalLanguageCodes)) continue;
            probabilities.put(langCode, probValue);
        }
        return probabilities;
    }

    void destroy() {
        this.fasttextProcess.destroy();
    }
}

