/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;

public class BasicJideButtonListener
extends BasicButtonListener {
    private boolean _mouseOver = false;

    public BasicJideButtonListener(AbstractButton b) {
        super(b);
    }

    public void mouseEntered(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(true);
        }
        this._mouseOver = true;
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String prop = e.getPropertyName();
        if ("buttonStyle".equals(prop) || "opaque".equals(prop) || "contentAreaFilled".equals(prop)) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.repaint();
        } else if ("orientation".equals(prop) || "hideActionText".equals(prop)) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.invalidate();
            b.repaint();
        } else if ("verticalTextPosition".equals(prop) || "horizontalTextPosition".equals(prop)) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.updateUI();
        }
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        this.cancelMenuIfNecessary(e);
    }

    public void mouseReleased(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.contains(e.getPoint()) && b.isRolloverEnabled()) {
            model.setRollover(true);
        }
        if (!this._mouseOver) {
            model.setArmed(false);
            model.setPressed(false);
        }
        super.mouseReleased(e);
        this.cancelMenuIfNecessary(e);
    }

    private void cancelMenuIfNecessary(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElements = manager.getSelectedPath();
        for (int i = menuElements.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElements[i];
            if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(b)) continue;
            b.getModel().setPressed(false);
            b.getModel().setArmed(false);
            b.getModel().setRollover(false);
            if (Boolean.FALSE.equals(b.getClientProperty("JideButton.hidePopupMenu"))) break;
            manager.clearSelectedPath();
            break;
        }
    }

    public void mouseExited(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled()) {
            model.setRollover(false);
        }
        model.setArmed(false);
        this._mouseOver = false;
    }

    void updateMnemonicBinding(AbstractButton b) {
        int m = b.getMnemonic();
        if (m != 0) {
            InputMap map = SwingUtilities.getUIInputMap(b, 2);
            if (map == null) {
                map = new ComponentInputMapUIResource(b);
                SwingUtilities.replaceUIInputMap(b, 2, map);
            }
            map.clear();
            map.put(KeyStroke.getKeyStroke(m, 8, false), "pressed");
            map.put(KeyStroke.getKeyStroke(m, 8, true), "released");
            map.put(KeyStroke.getKeyStroke(m, 0, true), "released");
        } else {
            InputMap map = SwingUtilities.getUIInputMap(b, 2);
            if (map != null) {
                map.clear();
            }
        }
    }

    static Object getUIOfType(ComponentUI ui, Class clazz) {
        if (clazz.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c) {
        BasicJideButtonUI ui;
        if (condition == 0 && (ui = (BasicJideButtonUI)BasicJideButtonListener.getUIOfType(((AbstractButton)c).getUI(), BasicJideButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + "focusInputMap");
        }
        return null;
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
    }

    public void installKeyboardActions(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        this.updateMnemonicBinding(b);
        LazyActionMap.installLazyActionMap(c, BasicJideButtonListener.class, "JideButton.actionMap");
        InputMap km = this.getInputMap(0, c);
        SwingUtilities.replaceUIInputMap(c, 0, km);
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            String key = this.getName();
            if (PRESS.equals(key)) {
                ButtonModel model = b.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                    b.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }
}

