/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.util.regex.PatternSyntaxException;
import org.omegat.core.Core;
import org.omegat.core.search.Searcher;
import org.omegat.core.threads.LongProcessInterruptedException;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.util.Log;

public class SearchThread
extends LongProcessThread {
    private SearchWindowController window;
    private Searcher searcher;

    public SearchThread(SearchWindowController window, Searcher searcher) {
        this.window = window;
        this.searcher = searcher;
        this.searcher.setThread(this);
    }

    @Override
    public void run() {
        try {
            try {
                this.searcher.search();
                this.checkInterrupted();
                this.window.displaySearchResult(this.searcher);
            }
            catch (LongProcessInterruptedException longProcessInterruptedException) {
            }
            catch (PatternSyntaxException e) {
                this.window.displayErrorRB(e, "ST_REGEXP_ERROR", new Object[0]);
            }
            catch (IndexOutOfBoundsException e) {
                this.window.displayErrorRB(e, "ST_REGEXP_REPLACE_ERROR", new Object[0]);
            }
            catch (Exception e) {
                Log.logErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
            }
        }
        catch (RuntimeException re) {
            Log.logErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
        }
    }
}

