/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.madlonkay.supertmxmerge.util.LocString;

public class GuiUtil {
    private static final Logger LOGGER = Logger.getLogger(GuiUtil.class.getName());

    public static void displayWindow(Window window) {
        window.pack();
        if (window.getParent() != null) {
            window.setLocationRelativeTo(window.getParent());
        }
        window.setVisible(true);
    }

    public static void displayWindowCentered(Window window) {
        window.pack();
        window.setLocationRelativeTo(null);
        window.setVisible(true);
    }

    public static void closeWindow(Window window) {
        window.setVisible(false);
        window.dispose();
    }

    public static void sizeForScreen(Component component) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxHeight = (int)((double)screen.height * 0.9);
        int maxWidth = Math.min(maxHeight, (int)((double)screen.width * 0.9));
        component.setMaximumSize(new Dimension(maxWidth, maxHeight));
        component.setPreferredSize(new Dimension(Math.min(800, maxWidth), Math.min(800, maxHeight)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockOnWindow(Window window) {
        final Object lock = new Object();
        window.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            while (window.isVisible()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void safelyRunBlockingRoutine(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    public static boolean isOSX() {
        return System.getProperty("os.name").contains("OS X");
    }

    public static void forwardMouseWheelEvent(JScrollPane target, MouseWheelEvent evt) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseWheelEvent((Component)target, evt.getID(), evt.getWhen(), evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), evt.getScrollType(), evt.getScrollAmount(), evt.getWheelRotation()));
    }

    public static void showError(String message) {
        JOptionPane.showMessageDialog(null, message, LocString.get("STM_ERROR_DIALOG_TITLE"), 0);
    }
}

