/*
HMImageTextFieldCell.h

Author: Makoto Kinoshita & MIURA Kazki

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

enum {
	HMNormalTextFieldType = 0,
    HMNumberedTextFieldType = 1, 
};

enum {
    HMBlackTextFieldNumber = 0, 
};

@interface HMImageTextFieldCell : NSTextFieldCell
{
    NSImage*    _image;
    id          _dragDelegate;
    int         _padding;
    
	BOOL		_focusOnlyTitle;
    BOOL        _focusRingIncludesImage;
    BOOL        _isSeparator;
    BOOL        _useBoldForHighlight;
	BOOL		_isEditing;
    
    int         _textFieldType;
    int         _textFieldNumberType;
    int         _number;
}

// Working with image
- (void)setImage:(NSImage*)image;
- (NSImage*)image;
- (int)paddingBetweenImageAndText;
- (void)setPaddingBetweenImageAndText:(int)padding;
- (BOOL)focusRingIncludesImage;
- (void)setFocusRingIncludesImage:(BOOL)flag;
- (BOOL)focusOnlyTitle;
- (void)setFocusOnlyTitle:(BOOL)flag;

// Text field type
- (int)textFieldType;
- (void)setTextFieldType:(int)type;
- (int)textFieldNumberType;
- (void)setTextFieldNumberType:(int)type;

// Numbered field
- (int)number;
- (void)setNumber:(int)number;

// Separator
- (BOOL)isSeparator;
- (void)setSeparator:(BOOL)isSepartor;

// Highlight
- (BOOL)useBoldForHighlight;
- (void)setUseBoldForHighlight:(BOOL)flag;

// Dragging and dropping
- (id)dragDelegate;
- (void)setDragDelegate:(id)delegate;
- (BOOL)shouldImageTrackMouse:(NSEvent*)event 
        inRect:(NSRect)cellFrame ofView:(NSView*)controlView;
- (BOOL)imageTrackMouse:(NSEvent*)event 
        inRect:(NSRect)cellFrame ofView:(NSView*)controlView;

// Drawing
- (void)drawImageWithFrame:(NSRect)cellFrame
		inView:(NSView*)controlView;
- (void)drawNumberWithFrame:(NSRect)cellFrame
		inView:(NSView*)controlView;
- (void)drawTitleWithFrame:(NSRect)cellFrame
		inView:(NSView*)controlView;

// Size
- (float)imageWidthWithSpace;
- (NSRect)imageRectForBounds:(NSRect)theRect;
- (NSRect)numberRectForBounds:(NSRect)theRect;
- (NSRect)titleRectForBounds:(NSRect)theRect;

// Text
- (BOOL)isEditing;

@end

@interface NSObject (HMImageTextFieldCellDelegate)
- (NSImage*)imageTextCell:(HMImageTextFieldCell*)cell 
        dragImageForEvent:(NSEvent*)event 
        inRect:(NSRect)cellFrame 
        ofView:(NSView*)controlView 
        dragImageOffset:(NSPointPointer)dragImageOffset;
- (BOOL)imageTextCell:(HMImageTextFieldCell*)cell 
        writeToPasteboard:(NSPasteboard*)pboard;
@end
