/*
SRPlugInRepresentation.m

Author: Makoto Kinoshita

Copyright 2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRPlugIn.h"
#import "SRPlugInProtocol.h"
#import "SRPlugInRepresentation.h"

@implementation SRPlugInRepresentation

//--------------------------------------------------------------//
#pragma mark -- Classes --
//--------------------------------------------------------------//

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

#if 0
- (id)init
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Create plug-in
    Class   plugInClass;
    plugInClass = [[self class] plugInClass];
    if (plugInClass) {
        _plugIn = [[plugInClass alloc] init];
    }
    
    return self;
}
#endif

- (void)dealloc
{
    [_plugIn release], _plugIn = nil;
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Controller --
//--------------------------------------------------------------//

- (SRPlugIn*)plugIn
{
    return _plugIn;
}

//--------------------------------------------------------------//
#pragma mark -- WebDocumentRepresentation protocol --
//--------------------------------------------------------------//

- (void)setDataSource:(WebDataSource*)dataSource
{
    if (_plugIn) {
        return;
    }
    
    // Get MIME type
    NSString*   MIMEType;
    MIMEType = [[dataSource response] MIMEType];
    
    // Get plug-in class
    Class   plugInClass;
    plugInClass = [SRPlugIn plugInClassForMIMEType:MIMEType];
    if (!plugInClass) {
        // Error
        NSLog(@"Can't find plug-in class for MIME, %@", MIMEType);
        return;
    }
    
    // Create plug-in
    _plugIn = [[plugInClass alloc] init];
}

- (void)receivedData:(NSData*)data withDataSource:(WebDataSource*)dataSource
{
}

- (void)receivedError:(NSError*)error withDataSource:(WebDataSource*)dataSource
{
}

- (void)finishedLoadingWithDataSource:(WebDataSource*)dataSource
{
}

- (BOOL)canProvideDocumentSource
{
    return NO;
}

- (NSString*)documentSource
{
    return nil;
}

- (NSString*)title
{
    return [_plugIn title];
}

@end
