/*
SRDownloadShelfTitleCell.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRDownloadItem.h"

#import "SRDownloadShelfTitleCell.h"

static const int    _statusIconMarginX = 4;
static const int    _statusIconSizeW = 14;
static const int    _fileIconSizeW = 32;
static const int    _titleMarginX = 2;

@implementation SRDownloadShelfTitleCell

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (void)drawInteriorWithFrame:(NSRect)cellFrame 
        inView:(NSView*)controlView
{
    NSRect  rect;
    
    // Get download item
    SRDownloadItem* item;
    item = [self objectValue];
    
    //
    // Draw status icon
    //
    
    // Get stauts
    int status;
    status = [[item valueForKey:@"status"] intValue];
    
    // Get status icon
    NSBundle*   bundle;
    NSString*   statusIconPath = nil;
    bundle = [NSBundle bundleForClass:[self class]];
    switch (status) {
    case SRDownloadStatusStarted:
    case SRDownloadStatusCommitted: {
        statusIconPath = [bundle pathForImageResource:@"downloadStatusProgress"];
        break;
    }
    case SRDownloadStatusPaused: {
        statusIconPath = [bundle pathForImageResource:@"downloadStatusCancel"];
        break;
    }
    case SRDownloadStatusError: {
        statusIconPath = [bundle pathForImageResource:@"downloadStatusError"];
        break;
    }
    }
    
    // Draw icon
    if (statusIconPath) {
        NSImage*    statusIcon;
        statusIcon = [[NSImage alloc] initWithContentsOfFile:statusIconPath];
        if ([statusIcon isFlipped] != [controlView isFlipped]) {
            [statusIcon setFlipped:[controlView isFlipped]];
        }
        
        NSRect  srcRect;
        srcRect.origin = NSZeroPoint;
        srcRect.size = [statusIcon size];
        
        rect.origin.x = cellFrame.origin.x + _statusIconMarginX;
        rect.origin.y = cellFrame.origin.y + (cellFrame.size.height - srcRect.size.height) / 2.0f;
        rect.size = srcRect.size;
        
        [statusIcon drawInRect:rect fromRect:srcRect operation:NSCompositeSourceOver fraction:1.0f];
        [statusIcon release];
    }
    
    //
    // Draw file icon
    //
    
    // Get file name
    NSString*   downloadedFileName;
    downloadedFileName = [item valueForKey:@"fileName"];
    if (!downloadedFileName) {
        downloadedFileName = @" "; // dummy
    }
    
    // Get file icon
    NSImage*    fileIcon;
    fileIcon = [[NSWorkspace sharedWorkspace] iconForFileType:[downloadedFileName pathExtension]];
    if (fileIcon) {
        if ([fileIcon isFlipped] != [controlView isFlipped]) {
            [fileIcon setFlipped:[controlView isFlipped]];
        }
        
        NSRect  srcRect;
        srcRect.origin = NSZeroPoint;
        srcRect.size = [fileIcon size];
        
        rect.origin.x = cellFrame.origin.x + _statusIconMarginX + _statusIconSizeW;
        rect.origin.y = cellFrame.origin.y + (cellFrame.size.height - srcRect.size.height) / 2.0f;
        rect.size.width = _fileIconSizeW;
        rect.size.height = _fileIconSizeW;
        
        [fileIcon drawInRect:rect fromRect:srcRect operation:NSCompositeSourceOver fraction:1.0f];
    }
    
    //
    // Draw title
    //
    
    // Create attributes
    static NSDictionary*    _smallSystemFont = nil;
    static NSDictionary*    _selectedSmallSystemFont = nil;
    if (!_smallSystemFont) {
        NSMutableParagraphStyle*    paragraph;
        paragraph = [[NSMutableParagraphStyle alloc] init];
        [paragraph setAlignment:NSLeftTextAlignment];
        [paragraph setLineBreakMode:NSLineBreakByTruncatingTail];
        
        _smallSystemFont = [[NSDictionary dictionaryWithObjectsAndKeys:
                [NSFont systemFontOfSize:[NSFont smallSystemFontSize]], NSFontAttributeName, 
                [NSColor blackColor], NSForegroundColorAttributeName, 
                paragraph, NSParagraphStyleAttributeName, 
                nil] retain];
        _selectedSmallSystemFont = [[NSDictionary dictionaryWithObjectsAndKeys:
                [NSFont systemFontOfSize:[NSFont smallSystemFontSize]], NSFontAttributeName, 
                [NSColor whiteColor], NSForegroundColorAttributeName, 
                paragraph, NSParagraphStyleAttributeName, 
                nil] retain];
        
        [paragraph release];
    }
    
    // Check whether the cell is active and highlighted
    BOOL	highlighted;
    highlighted = ([self isHighlighted] && 
            [[controlView window] isKeyWindow] && 
            [[controlView window] firstResponder] == controlView); 
    
    // Draw file name
    NSAttributedString* fileName;
    NSDictionary*       strAttributes;
    
    if (highlighted) {
        strAttributes = _selectedSmallSystemFont;
    }
    else {
        strAttributes = _smallSystemFont;
    }
    
    fileName = [[NSAttributedString alloc] 
            initWithString:downloadedFileName 
            attributes:strAttributes];
    [fileName autorelease];
    
    rect.size.width = cellFrame.size.width - 
            (_statusIconMarginX + _statusIconSizeW + _fileIconSizeW + _titleMarginX + 2 * _titleMarginX);
    rect.size.height = [fileName size].height;
    rect.origin.x = cellFrame.origin.x + 
            _statusIconMarginX + _statusIconSizeW + _fileIconSizeW + _titleMarginX;
    rect.origin.y = cellFrame.origin.y + (cellFrame.size.height - rect.size.height) / 2.0f;
    [fileName drawInRect:rect];
}

@end
