/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v3;

import antenna.preprocessor.v3.IPreprocessorListener;
import antenna.preprocessor.v3.PPException;
import antenna.preprocessor.v3.PPLine;
import antenna.preprocessor.v3.parser.Define;
import antenna.preprocessor.v3.parser.Defines;
import antenna.preprocessor.v3.parser.Literal;
import antenna.preprocessor.v3.parser.PPLineAST;
import java.util.StringTokenizer;
import java.util.Vector;
import org.antlr.runtime.RecognitionException;

public class CommandEvaluator {
    private static final String DEBUG_KEY = "DEBUG";
    public static final int UNKNOWN_LINE = -1;
    private final Defines m_defines;

    public CommandEvaluator(Defines defines) {
        this.m_defines = defines;
    }

    public boolean evaluate(PPLine ppl, PPLineAST ast, IPreprocessorListener listener) throws Exception, PPException {
        Eval eval = new Eval(ppl, ast, listener);
        return this.evaluate(eval);
    }

    private boolean evaluate(Eval ast) throws Exception, PPException {
        int type = ast.getType();
        switch (type) {
            case 30: 
            case 32: {
                return this.evalDefined(ast.getNextSibling());
            }
            case 27: 
            case 28: 
            case 29: {
                return this.evaluate(ast.getNextSibling());
            }
            case 20: 
            case 39: {
                return this.evaluateDebug(ast);
            }
            case 31: 
            case 33: {
                return !this.evaluate(ast.getNextSibling());
            }
            case 54: {
                Define define = this.m_defines.getDefine(ast.getText());
                if (define == null) {
                    return false;
                }
                if (define.getLiteral().isBoolean()) {
                    return define.getLiteral().isTrue();
                }
                return true;
            }
            case 59: {
                return this.EQ(ast);
            }
            case 15: {
                return this.NEQ(ast);
            }
            case 17: {
                return this.GT(ast);
            }
            case 16: {
                return this.LT(ast);
            }
            case 19: {
                return this.GTE(ast);
            }
            case 18: {
                return this.LTE(ast);
            }
            case 14: {
                return this.AT(ast);
            }
            case 57: {
                Eval left = ast.getFirstChild();
                Eval right = left.getNextSibling();
                return this.evaluate(left) && this.evaluate(right);
            }
            case 58: {
                Eval left = ast.getFirstChild();
                Eval right = left.getNextSibling();
                return this.evaluate(left) || this.evaluate(right);
            }
            case 13: {
                Eval left = ast.getFirstChild();
                Eval right = left.getNextSibling();
                return this.evaluate(left) ^ this.evaluate(right);
            }
            case 12: {
                return !this.evaluate(ast.getFirstChild());
            }
            case 25: {
                this.m_defines.define(ast.getNextSibling().ast);
                return true;
            }
            case 26: {
                String def = ast.getNextSibling().getText();
                boolean removed = this.m_defines.undefine(def);
                if (!removed) {
                    System.err.println("Warning: attempting to undefine \"" + def + "\" which is not defined");
                }
                return true;
            }
        }
        throw new UnsupportedOperationException("Error evaluating expression " + (ast != null ? ast.ppl.getSource() : ""));
    }

    private boolean evalDefined(Eval eval) {
        return this.m_defines.isDefined(eval.getText());
    }

    private boolean evaluateDebug(Eval eval) throws PPException {
        boolean debugDefined = this.m_defines.isDefined(DEBUG_KEY);
        if (!debugDefined) {
            return false;
        }
        PPLineAST nextSibling = (PPLineAST)eval.ast.getParent().getChild(eval.ast.getIndex() + 1);
        if (nextSibling == null) {
            return debugDefined;
        }
        Define define = this.m_defines.getDefine(DEBUG_KEY);
        String currentValue = define.getLiteral().getValue();
        int currentLevel = this.getDebugLevelNumber(currentValue);
        if (currentLevel == -1) {
            throw new PPException("Unknown debug value " + currentValue);
        }
        String level = nextSibling.getText();
        int lineLevel = this.getDebugLevelNumber(level);
        if (lineLevel == -1) {
            throw new PPException("Unknown debug value " + level);
        }
        return lineLevel >= currentLevel;
    }

    private int getDebugLevelNumber(String value) {
        int level = -1;
        if (value.equalsIgnoreCase("debug") || value.equalsIgnoreCase("true")) {
            level = 0;
        }
        if (value.equalsIgnoreCase("info")) {
            level = 1;
        }
        if (value.equalsIgnoreCase("warn")) {
            level = 2;
        }
        if (value.equalsIgnoreCase("error")) {
            level = 3;
        }
        if (value.equalsIgnoreCase("fatal")) {
            level = 4;
        }
        return level;
    }

    private boolean AT(Eval ast) throws Exception {
        Eval left = ast.getFirstChild();
        Eval right = left.getNextSibling();
        Literal[] llist = this.values(left);
        Literal[] rlist = this.values(right);
        for (int i = 0; i < llist.length; ++i) {
            Literal literal = llist[i];
            for (int j = 0; j < rlist.length; ++j) {
                if (!literal.getValue().equals(rlist[j].getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean GTE(Eval ast) throws Exception {
        Literal rval;
        Eval left = ast.getFirstChild();
        Eval right = left.getNextSibling();
        Literal lval = this.singleValue(left);
        return !this.ltImpl(lval, rval = this.singleValue(right));
    }

    private boolean LTE(Eval ast) throws Exception {
        Literal rval;
        Eval left = ast.getFirstChild();
        Eval right = left.getNextSibling();
        Literal lval = this.singleValue(left);
        return !this.gtImpl(lval, rval = this.singleValue(right));
    }

    private boolean LT(Eval ast) throws RecognitionException {
        Eval left = ast.getFirstChild();
        Eval right = left.getNextSibling();
        Literal lval = this.singleValue(left);
        Literal rval = this.singleValue(right);
        return this.ltImpl(lval, rval);
    }

    private boolean GT(Eval ast) throws RecognitionException {
        Eval left = ast.getFirstChild();
        Eval right = left.getNextSibling();
        Literal lval = this.singleValue(left);
        Literal rval = this.singleValue(right);
        return this.gtImpl(lval, rval);
    }

    private boolean EQ(Eval ast) throws RecognitionException {
        return this.eqImpl(ast);
    }

    private boolean NEQ(Eval ast) throws RecognitionException {
        return !this.eqImpl(ast);
    }

    private Literal[] values(Eval ast) throws Exception {
        return this.values(ast, true);
    }

    private Literal[] values(Eval ast, boolean warnIfNotDefined) throws Exception {
        int type = ast.getType();
        String text = ast.getText();
        switch (type) {
            case 54: {
                Define v = this.m_defines.getDefine(text);
                if (v != null) {
                    Literal lit = v.getLiteral();
                    return this.getValues(lit.getValue());
                }
                ast.warning(this.emptySymbolWarning(text));
                return this.literals(new Literal(56, ""));
            }
            case 56: {
                String str = text;
                return this.getValues(str);
            }
            case 55: {
                return this.literals(new Literal(type, text));
            }
        }
        throw new RecognitionException();
    }

    private Literal[] getValues(String str) throws RecognitionException {
        StringTokenizer tok = new StringTokenizer(str, ", ");
        Vector<Literal> vec = new Vector<Literal>();
        while (tok.hasMoreElements()) {
            String t = tok.nextToken();
            Literal literal = new Literal(56, t);
            vec.addElement(literal);
        }
        Object[] ls = new Literal[vec.size()];
        vec.copyInto(ls);
        return ls;
    }

    private Literal singleValue(Eval ast) throws RecognitionException {
        int type = ast.getType();
        String text = ast.getText();
        switch (type) {
            case 54: {
                Define v = this.m_defines.getDefine(text);
                if (v != null) {
                    return v.getLiteral();
                }
                ast.warning(this.emptySymbolWarning(text));
                return new Literal(56, "");
            }
            case 55: 
            case 56: {
                return new Literal(type, text);
            }
        }
        throw new RecognitionException();
    }

    private String emptySymbolWarning(String text) {
        return "Symbol " + text + " is not defined, using empty string";
    }

    private Literal[] literals(Literal value) {
        return new Literal[]{value};
    }

    private boolean eqImpl(Eval ast) throws RecognitionException {
        Eval left = ast.getFirstChild();
        Eval right = left.getNextSibling();
        Literal lval = this.singleValue(left);
        Literal rval = this.singleValue(right);
        if (lval.isNumber() ^ rval.isNumber()) {
            String number = lval.isNumber() ? left.getText() : right.getText();
            ast.warning("Number " + number + " is compared lexicographically");
        }
        if (lval.isNumber() && rval.isNumber()) {
            double d2;
            double d1 = Double.parseDouble(rval.getValue());
            return d1 == (d2 = Double.parseDouble(lval.getValue()));
        }
        return lval.getValue().equals(rval.getValue());
    }

    private boolean gtImpl(Literal lval, Literal rval) {
        if (lval.isNumber() && rval.isNumber()) {
            double d2;
            double d1 = Double.parseDouble(rval.getValue());
            return d1 < (d2 = Double.parseDouble(lval.getValue()));
        }
        return lval.getValue().compareTo(rval.getValue()) > 0;
    }

    private boolean ltImpl(Literal lval, Literal rval) {
        if (lval.isNumber() && rval.isNumber()) {
            double d2;
            double d1 = Double.parseDouble(rval.getValue());
            return d1 > (d2 = Double.parseDouble(lval.getValue()));
        }
        return lval.getValue().compareTo(rval.getValue()) < 0;
    }

    private static class Eval {
        public PPLine ppl;
        public PPLineAST ast;
        public IPreprocessorListener listener;

        public Eval(PPLine ppl, PPLineAST ast, IPreprocessorListener listener) {
            this.ppl = ppl;
            this.ast = ast;
            this.listener = listener;
        }

        public void warning(String message) {
            if (this.listener != null) {
                int ln = this.ppl.getLineNumber() + 1;
                this.listener.warning(message, ln, this.ast.getCharPositionInLine(), this.getText().length());
            }
        }

        public String getText() {
            return this.ast.getText();
        }

        public int getType() {
            return this.ast.getType();
        }

        public Eval getFirstChild() {
            return new Eval(this.ppl, (PPLineAST)this.ast.getChild(0), this.listener);
        }

        public Eval getNextSibling() {
            return new Eval(this.ppl, (PPLineAST)this.ast.getParent().getChild(this.ast.getIndex() + 1), this.listener);
        }

        public String toString() {
            return this.ast.toString();
        }

        public int getColumn() {
            return this.ast.getCharPositionInLine();
        }
    }
}

