/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v3.parser;

import antenna.preprocessor.v3.ILineFilter;
import antenna.preprocessor.v3.parser.APPLexer;
import antenna.preprocessor.v3.parser.APPParser;
import antenna.preprocessor.v3.parser.Define;
import antenna.preprocessor.v3.parser.Literal;
import antenna.preprocessor.v3.parser.PPLineAST;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;

public class Defines {
    private Hashtable m_defines;
    private final ILineFilter m_lineFilter;

    public Defines() {
        this.m_lineFilter = null;
        this.clear();
    }

    public Defines(ILineFilter lineFilter) {
        this.m_lineFilter = lineFilter;
        this.clear();
    }

    public Defines(String defines) throws RecognitionException, IOException {
        this.m_lineFilter = null;
        this.clear();
        this.addDefines(defines);
    }

    public Defines(String defines, ILineFilter lineFilter) throws RecognitionException, IOException {
        this.m_lineFilter = lineFilter;
        this.clear();
        this.addDefines(defines);
    }

    public void addDefines(String defines) throws RecognitionException, IOException {
        APPLexer lexer = new APPLexer(new ANTLRReaderStream(new StringReader(defines)));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        APPParser parser = new APPParser(tokens);
        parser.setTreeAdaptor(PPLineAST.adaptor);
        APPParser.defines_return defines_return2 = parser.defines();
        PPLineAST returnAST = (PPLineAST)defines_return2.getTree();
        PPLineAST.fillParentInfo(returnAST);
        try {
            if (returnAST.isNil()) {
                for (int i = 0; i < returnAST.getChildCount(); ++i) {
                    PPLineAST t = (PPLineAST)returnAST.getChild(i);
                    while (t != null && t.getType() != -1) {
                        this.define(t);
                        t = (PPLineAST)t.getParent().getChild(t.getIndex() + 1);
                    }
                }
            } else {
                PPLineAST node = returnAST;
                while (node != null && node.getType() != -1) {
                    this.define(node);
                    node = (PPLineAST)node.getParent().getChild(node.getIndex() + 1);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefines(File file) throws IOException, RecognitionException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.loadDefines(in);
        }
        finally {
            in.close();
        }
    }

    public void loadDefines(InputStream in) throws RecognitionException, IOException {
        Hashtable backup = (Hashtable)this.m_defines.clone();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (this.m_lineFilter != null) {
                    line = this.m_lineFilter.filter(line);
                }
                APPLexer lexer = new APPLexer(new ANTLRReaderStream(new StringReader(line)));
                TokenRewriteStream tokens = new TokenRewriteStream(lexer);
                APPParser parser = new APPParser(tokens);
                parser.setTreeAdaptor(PPLineAST.adaptor);
                APPParser.define_return define_return2 = parser.define();
                PPLineAST returnAST = (PPLineAST)define_return2.getTree();
                PPLineAST.fillParentInfo(returnAST);
                this.define(returnAST);
            }
        }
        catch (RecognitionException e) {
            this.m_defines = backup;
            throw e;
        }
        catch (IOException e) {
            this.m_defines = backup;
            throw e;
        }
    }

    public void define(String key) throws RecognitionException, IOException {
        this.define(key, null);
    }

    public void define(String key, String value) throws RecognitionException, IOException {
        String def = value == null ? key : key + "=" + value;
        APPLexer lexer = new APPLexer(new ANTLRReaderStream(new StringReader(def)));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        APPParser parser = new APPParser(tokens);
        parser.setTreeAdaptor(PPLineAST.adaptor);
        APPParser.define_return define_return2 = parser.define();
        PPLineAST returnAST = (PPLineAST)define_return2.getTree();
        PPLineAST.fillParentInfo(returnAST);
        this.define(returnAST);
    }

    public void define(PPLineAST node) throws RecognitionException {
        Literal literal;
        String key = node.getText();
        int action = -1;
        if (node.getChild(0) != null && (node.getChild(0).getType() == 42 || node.getChild(0).getType() == 41)) {
            action = node.getChild(0).getType();
            node = (PPLineAST)node.getChild(0);
            node = (PPLineAST)node.getParent().getChild(node.getIndex() + 1);
            node = (PPLineAST)node.getParent().getChild(node.getIndex() + 1);
        } else {
            node = (PPLineAST)node.getChild(0);
        }
        if (node != null) {
            String st = node.getText();
            if (node.getType() == 56) {
                st = st.substring(1, st.length() - 1);
            }
            literal = new Literal(node.getType(), st);
        } else {
            literal = new Literal(-1, "true");
        }
        Define define = new Define(key, literal);
        switch (action) {
            case -1: {
                this.m_defines.put(key, define);
                break;
            }
            case 42: {
                if (this.m_defines.containsKey(key)) break;
                this.m_defines.put(key, define);
                break;
            }
            case 41: {
                this.m_defines.remove(key);
                break;
            }
            default: {
                throw new RecognitionException();
            }
        }
    }

    public boolean isDefined(String text) {
        return this.m_defines.containsKey(text);
    }

    public Define getDefine(String text) {
        return (Define)this.m_defines.get(text);
    }

    public boolean undefine(String key) {
        return this.m_defines.remove(key) != null;
    }

    public String toString() {
        Enumeration keys = this.m_defines.keys();
        Vector<String> v = new Vector<String>(this.m_defines.size());
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            v.add(key);
        }
        Collections.sort(v, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s1 = (String)arg0;
                String s2 = (String)arg1;
                if (s1 != null) {
                    s1 = s1.toLowerCase();
                }
                if (s2 != null) {
                    s2 = s2.toLowerCase();
                }
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null) {
                    return -1;
                }
                if (s2 == null) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        });
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            String key = (String)v.get(i);
            Define def = (Define)this.m_defines.get(key);
            b.append(def);
            b.append("\n");
        }
        return b.toString();
    }

    public String[] keys() {
        String[] keys = new String[this.m_defines.size()];
        this.m_defines.keySet().toArray(keys);
        return keys;
    }

    public Define[] values() {
        Define[] defines = new Define[this.m_defines.size()];
        this.m_defines.values().toArray(defines);
        return defines;
    }

    public Defines copy() {
        Defines copy = new Defines();
        copy.m_defines = (Hashtable)this.m_defines.clone();
        return copy;
    }

    public void clear() {
        this.m_defines = new Hashtable();
    }
}

