/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.Resources;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.SortedMap;

public class PgDiffArguments {
    private String inCharsetName = "UTF-8";
    private String newDumpFile;
    private String oldDumpFile;
    private String outCharsetName = "UTF-8";
    private boolean addDefaults;
    private boolean addTransaction;
    private boolean ignoreFunctionWhitespace;
    private boolean ignoreStartWith;
    private boolean version;
    private boolean outputIgnoredStatements;
    private boolean listCharsets;
    private boolean ignoreSlonyTriggers;

    public void setAddDefaults(boolean addDefaults) {
        this.addDefaults = addDefaults;
    }

    public boolean isAddDefaults() {
        return this.addDefaults;
    }

    public void setAddTransaction(boolean addTransaction) {
        this.addTransaction = addTransaction;
    }

    public boolean isAddTransaction() {
        return this.addTransaction;
    }

    public void setIgnoreFunctionWhitespace(boolean ignoreFunctionWhitespace) {
        this.ignoreFunctionWhitespace = ignoreFunctionWhitespace;
    }

    public boolean isIgnoreFunctionWhitespace() {
        return this.ignoreFunctionWhitespace;
    }

    public void setIgnoreStartWith(boolean ignoreStartWith) {
        this.ignoreStartWith = ignoreStartWith;
    }

    public boolean isIgnoreStartWith() {
        return this.ignoreStartWith;
    }

    public void setNewDumpFile(String newDumpFile) {
        this.newDumpFile = newDumpFile;
    }

    public String getNewDumpFile() {
        return this.newDumpFile;
    }

    public void setOldDumpFile(String oldDumpFile) {
        this.oldDumpFile = oldDumpFile;
    }

    public String getOldDumpFile() {
        return this.oldDumpFile;
    }

    public boolean isOutputIgnoredStatements() {
        return this.outputIgnoredStatements;
    }

    public void setOutputIgnoredStatements(boolean outputIgnoredStatements) {
        this.outputIgnoredStatements = outputIgnoredStatements;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean parse(PrintWriter writer, String[] args) {
        boolean success = true;
        int argsLength = args.length >= 2 ? args.length - 2 : args.length;
        for (int i = 0; i < argsLength; ++i) {
            if ("--add-defaults".equals(args[i])) {
                this.setAddDefaults(true);
                continue;
            }
            if ("--add-transaction".equals(args[i])) {
                this.setAddTransaction(true);
                continue;
            }
            if ("--ignore-function-whitespace".equals(args[i])) {
                this.setIgnoreFunctionWhitespace(true);
                continue;
            }
            if ("--ignore-slony-triggers".equals(args[i])) {
                this.setIgnoreSlonyTriggers(true);
                continue;
            }
            if ("--ignore-start-with".equals(args[i])) {
                this.setIgnoreStartWith(true);
                continue;
            }
            if ("--in-charset-name".equals(args[i])) {
                this.setInCharsetName(args[i + 1]);
                ++i;
                continue;
            }
            if ("--list-charsets".equals(args[i])) {
                this.setListCharsets(true);
                continue;
            }
            if ("--out-charset-name".equals(args[i])) {
                this.setOutCharsetName(args[i + 1]);
                ++i;
                continue;
            }
            if ("--output-ignored-statements".equals(args[i])) {
                this.setOutputIgnoredStatements(true);
                continue;
            }
            if ("--version".equals(args[i])) {
                this.setVersion(true);
                continue;
            }
            writer.print(Resources.getString("ErrorUnknownOption"));
            writer.print(": ");
            writer.println(args[i]);
            success = false;
            break;
        }
        if (args.length == 1 && this.isVersion()) {
            this.printVersion(writer);
            success = false;
        } else if (args.length == 1 && this.isListCharsets()) {
            this.listCharsets(writer);
            success = false;
        } else if (args.length < 2) {
            this.printUsage(writer);
            success = false;
        } else if (success) {
            this.setOldDumpFile(args[args.length - 2]);
            this.setNewDumpFile(args[args.length - 1]);
        }
        return success;
    }

    private void printUsage(PrintWriter writer) {
        writer.println(Resources.getString("UsageHelp").replace("${tab}", "\t"));
    }

    private void printVersion(PrintWriter writer) {
        writer.print(Resources.getString("Version"));
        writer.print(": ");
        writer.println(Resources.getString("VersionNumber"));
    }

    public String getInCharsetName() {
        return this.inCharsetName;
    }

    public void setInCharsetName(String inCharsetName) {
        this.inCharsetName = inCharsetName;
    }

    public String getOutCharsetName() {
        return this.outCharsetName;
    }

    public void setOutCharsetName(String outCharsetName) {
        this.outCharsetName = outCharsetName;
    }

    public boolean isListCharsets() {
        return this.listCharsets;
    }

    public void setListCharsets(boolean listCharsets) {
        this.listCharsets = listCharsets;
    }

    private void listCharsets(PrintWriter writer) {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        for (String name : charsets.keySet()) {
            writer.println(name);
        }
    }

    public boolean isIgnoreSlonyTriggers() {
        return this.ignoreSlonyTriggers;
    }

    public void setIgnoreSlonyTriggers(boolean ignoreSlonyTriggers) {
        this.ignoreSlonyTriggers = ignoreSlonyTriggers;
    }
}

