/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.schema.PgDatabase;
import java.util.ArrayList;
import java.util.List;

public class ParserUtils {
    public static String getObjectName(String name) {
        String[] names = ParserUtils.splitNames(name);
        return names[names.length - 1];
    }

    public static String getSecondObjectName(String name) {
        String[] names = ParserUtils.splitNames(name);
        return names[names.length - 2];
    }

    public static String getThirdObjectName(String name) {
        String[] names = ParserUtils.splitNames(name);
        return names.length >= 3 ? names[names.length - 3] : null;
    }

    public static String getSchemaName(String name, PgDatabase database) {
        String[] names = ParserUtils.splitNames(name);
        if (names.length < 2) {
            return database.getDefaultSchema().getName();
        }
        return names[0];
    }

    public static String generateName(String prefix, List<String> names, String postfix) {
        String adjName;
        if (names.size() == 1) {
            adjName = names.get(0);
        } else {
            StringBuilder sbString = new StringBuilder(names.size() * 15);
            for (String name : names) {
                if (sbString.length() > 0) {
                    sbString.append(',');
                }
                sbString.append(name);
            }
            adjName = Integer.toHexString(sbString.toString().hashCode());
        }
        StringBuilder sbResult = new StringBuilder(30);
        if (prefix != null && !prefix.isEmpty()) {
            sbResult.append(prefix);
        }
        sbResult.append(adjName);
        if (postfix != null && !postfix.isEmpty()) {
            sbResult.append(postfix);
        }
        return sbResult.toString();
    }

    private static String[] splitNames(String string) {
        if (string.indexOf(34) == -1) {
            return string.split("\\.");
        }
        ArrayList<String> strings = new ArrayList<String>(2);
        int startPos = 0;
        while (true) {
            int endPos;
            if (string.charAt(startPos) == '\"') {
                endPos = string.indexOf(34, startPos + 1);
                strings.add(string.substring(startPos + 1, endPos));
                if (endPos + 1 == string.length()) break;
                if (string.charAt(endPos + 1) == '.') {
                    startPos = endPos + 2;
                    continue;
                }
                startPos = endPos + 1;
                continue;
            }
            endPos = string.indexOf(46, startPos);
            if (endPos == -1) {
                strings.add(string.substring(startPos));
                break;
            }
            strings.add(string.substring(startPos, endPos));
            startPos = endPos + 1;
        }
        return strings.toArray(new String[strings.size()]);
    }

    private ParserUtils() {
    }
}

