/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;

public class PgIndex {
    private String definition;
    private String name;
    private String tableName;
    private boolean unique;
    private String comment;

    public PgIndex(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(100);
        sbSQL.append("CREATE ");
        if (this.isUnique()) {
            sbSQL.append("UNIQUE ");
        }
        sbSQL.append("INDEX ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getName()));
        sbSQL.append(" ON ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getTableName()));
        sbSQL.append(' ');
        sbSQL.append(this.getDefinition());
        sbSQL.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON INDEX ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDropSQL() {
        return "DROP INDEX " + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof PgIndex) {
            PgIndex index = (PgIndex)object;
            equals = this.definition.equals(index.getDefinition()) && this.name.equals(index.getName()) && this.tableName.equals(index.getTableName()) && this.unique == index.isUnique();
        }
        return equals;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + this.definition + "|" + this.name + "|" + this.tableName + "|" + this.unique).hashCode();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }
}

